/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ContractCostType implements XdrElement
{
    WasmInsnExec(0),
    MemAlloc(1),
    MemCpy(2),
    MemCmp(3),
    DispatchHostFunction(4),
    VisitObject(5),
    ValSer(6),
    ValDeser(7),
    ComputeSha256Hash(8),
    ComputeEd25519PubKey(9),
    VerifyEd25519Sig(10),
    VmInstantiation(11),
    VmCachedInstantiation(12),
    InvokeVmFunction(13),
    ComputeKeccak256Hash(14),
    DecodeEcdsaCurve256Sig(15),
    RecoverEcdsaSecp256k1Key(16),
    Int256AddSub(17),
    Int256Mul(18),
    Int256Div(19),
    Int256Pow(20),
    Int256Shift(21),
    ChaCha20DrawBytes(22),
    ParseWasmInstructions(23),
    ParseWasmFunctions(24),
    ParseWasmGlobals(25),
    ParseWasmTableEntries(26),
    ParseWasmTypes(27),
    ParseWasmDataSegments(28),
    ParseWasmElemSegments(29),
    ParseWasmImports(30),
    ParseWasmExports(31),
    ParseWasmDataSegmentBytes(32),
    InstantiateWasmInstructions(33),
    InstantiateWasmFunctions(34),
    InstantiateWasmGlobals(35),
    InstantiateWasmTableEntries(36),
    InstantiateWasmTypes(37),
    InstantiateWasmDataSegments(38),
    InstantiateWasmElemSegments(39),
    InstantiateWasmImports(40),
    InstantiateWasmExports(41),
    InstantiateWasmDataSegmentBytes(42),
    Sec1DecodePointUncompressed(43),
    VerifyEcdsaSecp256r1Sig(44),
    Bls12381EncodeFp(45),
    Bls12381DecodeFp(46),
    Bls12381G1CheckPointOnCurve(47),
    Bls12381G1CheckPointInSubgroup(48),
    Bls12381G2CheckPointOnCurve(49),
    Bls12381G2CheckPointInSubgroup(50),
    Bls12381G1ProjectiveToAffine(51),
    Bls12381G2ProjectiveToAffine(52),
    Bls12381G1Add(53),
    Bls12381G1Mul(54),
    Bls12381G1Msm(55),
    Bls12381MapFpToG1(56),
    Bls12381HashToG1(57),
    Bls12381G2Add(58),
    Bls12381G2Mul(59),
    Bls12381G2Msm(60),
    Bls12381MapFp2ToG2(61),
    Bls12381HashToG2(62),
    Bls12381Pairing(63),
    Bls12381FrFromU256(64),
    Bls12381FrToU256(65),
    Bls12381FrAddSub(66),
    Bls12381FrMul(67),
    Bls12381FrPow(68),
    Bls12381FrInv(69);

    private final int value;

    private ContractCostType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ContractCostType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return WasmInsnExec;
            }
            case 1: {
                return MemAlloc;
            }
            case 2: {
                return MemCpy;
            }
            case 3: {
                return MemCmp;
            }
            case 4: {
                return DispatchHostFunction;
            }
            case 5: {
                return VisitObject;
            }
            case 6: {
                return ValSer;
            }
            case 7: {
                return ValDeser;
            }
            case 8: {
                return ComputeSha256Hash;
            }
            case 9: {
                return ComputeEd25519PubKey;
            }
            case 10: {
                return VerifyEd25519Sig;
            }
            case 11: {
                return VmInstantiation;
            }
            case 12: {
                return VmCachedInstantiation;
            }
            case 13: {
                return InvokeVmFunction;
            }
            case 14: {
                return ComputeKeccak256Hash;
            }
            case 15: {
                return DecodeEcdsaCurve256Sig;
            }
            case 16: {
                return RecoverEcdsaSecp256k1Key;
            }
            case 17: {
                return Int256AddSub;
            }
            case 18: {
                return Int256Mul;
            }
            case 19: {
                return Int256Div;
            }
            case 20: {
                return Int256Pow;
            }
            case 21: {
                return Int256Shift;
            }
            case 22: {
                return ChaCha20DrawBytes;
            }
            case 23: {
                return ParseWasmInstructions;
            }
            case 24: {
                return ParseWasmFunctions;
            }
            case 25: {
                return ParseWasmGlobals;
            }
            case 26: {
                return ParseWasmTableEntries;
            }
            case 27: {
                return ParseWasmTypes;
            }
            case 28: {
                return ParseWasmDataSegments;
            }
            case 29: {
                return ParseWasmElemSegments;
            }
            case 30: {
                return ParseWasmImports;
            }
            case 31: {
                return ParseWasmExports;
            }
            case 32: {
                return ParseWasmDataSegmentBytes;
            }
            case 33: {
                return InstantiateWasmInstructions;
            }
            case 34: {
                return InstantiateWasmFunctions;
            }
            case 35: {
                return InstantiateWasmGlobals;
            }
            case 36: {
                return InstantiateWasmTableEntries;
            }
            case 37: {
                return InstantiateWasmTypes;
            }
            case 38: {
                return InstantiateWasmDataSegments;
            }
            case 39: {
                return InstantiateWasmElemSegments;
            }
            case 40: {
                return InstantiateWasmImports;
            }
            case 41: {
                return InstantiateWasmExports;
            }
            case 42: {
                return InstantiateWasmDataSegmentBytes;
            }
            case 43: {
                return Sec1DecodePointUncompressed;
            }
            case 44: {
                return VerifyEcdsaSecp256r1Sig;
            }
            case 45: {
                return Bls12381EncodeFp;
            }
            case 46: {
                return Bls12381DecodeFp;
            }
            case 47: {
                return Bls12381G1CheckPointOnCurve;
            }
            case 48: {
                return Bls12381G1CheckPointInSubgroup;
            }
            case 49: {
                return Bls12381G2CheckPointOnCurve;
            }
            case 50: {
                return Bls12381G2CheckPointInSubgroup;
            }
            case 51: {
                return Bls12381G1ProjectiveToAffine;
            }
            case 52: {
                return Bls12381G2ProjectiveToAffine;
            }
            case 53: {
                return Bls12381G1Add;
            }
            case 54: {
                return Bls12381G1Mul;
            }
            case 55: {
                return Bls12381G1Msm;
            }
            case 56: {
                return Bls12381MapFpToG1;
            }
            case 57: {
                return Bls12381HashToG1;
            }
            case 58: {
                return Bls12381G2Add;
            }
            case 59: {
                return Bls12381G2Mul;
            }
            case 60: {
                return Bls12381G2Msm;
            }
            case 61: {
                return Bls12381MapFp2ToG2;
            }
            case 62: {
                return Bls12381HashToG2;
            }
            case 63: {
                return Bls12381Pairing;
            }
            case 64: {
                return Bls12381FrFromU256;
            }
            case 65: {
                return Bls12381FrToU256;
            }
            case 66: {
                return Bls12381FrAddSub;
            }
            case 67: {
                return Bls12381FrMul;
            }
            case 68: {
                return Bls12381FrPow;
            }
            case 69: {
                return Bls12381FrInv;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ContractCostType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractCostType.fromXdrByteArray(bytes);
    }

    public static ContractCostType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractCostType.decode(xdrDataInputStream);
    }
}

