/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ColdArchiveBucketEntry;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.ProofLevel;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ExistenceProofBody
implements XdrElement {
    private LedgerKey[] keysToProve;
    private ColdArchiveBucketEntry[] lowBoundEntries;
    private ColdArchiveBucketEntry[] highBoundEntries;
    private ProofLevel[] proofLevels;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int keysToProveSize = this.getKeysToProve().length;
        stream.writeInt(keysToProveSize);
        for (int i = 0; i < keysToProveSize; ++i) {
            this.keysToProve[i].encode(stream);
        }
        int lowBoundEntriesSize = this.getLowBoundEntries().length;
        stream.writeInt(lowBoundEntriesSize);
        for (int i = 0; i < lowBoundEntriesSize; ++i) {
            this.lowBoundEntries[i].encode(stream);
        }
        int highBoundEntriesSize = this.getHighBoundEntries().length;
        stream.writeInt(highBoundEntriesSize);
        for (int i = 0; i < highBoundEntriesSize; ++i) {
            this.highBoundEntries[i].encode(stream);
        }
        int proofLevelsSize = this.getProofLevels().length;
        stream.writeInt(proofLevelsSize);
        for (int i = 0; i < proofLevelsSize; ++i) {
            this.proofLevels[i].encode(stream);
        }
    }

    public static ExistenceProofBody decode(XdrDataInputStream stream) throws IOException {
        ExistenceProofBody decodedExistenceProofBody = new ExistenceProofBody();
        int keysToProveSize = stream.readInt();
        decodedExistenceProofBody.keysToProve = new LedgerKey[keysToProveSize];
        for (int i = 0; i < keysToProveSize; ++i) {
            decodedExistenceProofBody.keysToProve[i] = LedgerKey.decode(stream);
        }
        int lowBoundEntriesSize = stream.readInt();
        decodedExistenceProofBody.lowBoundEntries = new ColdArchiveBucketEntry[lowBoundEntriesSize];
        for (int i = 0; i < lowBoundEntriesSize; ++i) {
            decodedExistenceProofBody.lowBoundEntries[i] = ColdArchiveBucketEntry.decode(stream);
        }
        int highBoundEntriesSize = stream.readInt();
        decodedExistenceProofBody.highBoundEntries = new ColdArchiveBucketEntry[highBoundEntriesSize];
        for (int i = 0; i < highBoundEntriesSize; ++i) {
            decodedExistenceProofBody.highBoundEntries[i] = ColdArchiveBucketEntry.decode(stream);
        }
        int proofLevelsSize = stream.readInt();
        decodedExistenceProofBody.proofLevels = new ProofLevel[proofLevelsSize];
        for (int i = 0; i < proofLevelsSize; ++i) {
            decodedExistenceProofBody.proofLevels[i] = ProofLevel.decode(stream);
        }
        return decodedExistenceProofBody;
    }

    public static ExistenceProofBody fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ExistenceProofBody.fromXdrByteArray(bytes);
    }

    public static ExistenceProofBody fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ExistenceProofBody.decode(xdrDataInputStream);
    }

    @Generated
    public static ExistenceProofBodyBuilder builder() {
        return new ExistenceProofBodyBuilder();
    }

    @Generated
    public ExistenceProofBodyBuilder toBuilder() {
        return new ExistenceProofBodyBuilder().keysToProve(this.keysToProve).lowBoundEntries(this.lowBoundEntries).highBoundEntries(this.highBoundEntries).proofLevels(this.proofLevels);
    }

    @Generated
    public LedgerKey[] getKeysToProve() {
        return this.keysToProve;
    }

    @Generated
    public ColdArchiveBucketEntry[] getLowBoundEntries() {
        return this.lowBoundEntries;
    }

    @Generated
    public ColdArchiveBucketEntry[] getHighBoundEntries() {
        return this.highBoundEntries;
    }

    @Generated
    public ProofLevel[] getProofLevels() {
        return this.proofLevels;
    }

    @Generated
    public void setKeysToProve(LedgerKey[] keysToProve) {
        this.keysToProve = keysToProve;
    }

    @Generated
    public void setLowBoundEntries(ColdArchiveBucketEntry[] lowBoundEntries) {
        this.lowBoundEntries = lowBoundEntries;
    }

    @Generated
    public void setHighBoundEntries(ColdArchiveBucketEntry[] highBoundEntries) {
        this.highBoundEntries = highBoundEntries;
    }

    @Generated
    public void setProofLevels(ProofLevel[] proofLevels) {
        this.proofLevels = proofLevels;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExistenceProofBody)) {
            return false;
        }
        ExistenceProofBody other = (ExistenceProofBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getKeysToProve(), other.getKeysToProve())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLowBoundEntries(), other.getLowBoundEntries())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHighBoundEntries(), other.getHighBoundEntries())) {
            return false;
        }
        return Arrays.deepEquals(this.getProofLevels(), other.getProofLevels());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExistenceProofBody;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getKeysToProve());
        result = result * 59 + Arrays.deepHashCode(this.getLowBoundEntries());
        result = result * 59 + Arrays.deepHashCode(this.getHighBoundEntries());
        result = result * 59 + Arrays.deepHashCode(this.getProofLevels());
        return result;
    }

    @Generated
    public String toString() {
        return "ExistenceProofBody(keysToProve=" + Arrays.deepToString(this.getKeysToProve()) + ", lowBoundEntries=" + Arrays.deepToString(this.getLowBoundEntries()) + ", highBoundEntries=" + Arrays.deepToString(this.getHighBoundEntries()) + ", proofLevels=" + Arrays.deepToString(this.getProofLevels()) + ")";
    }

    @Generated
    public ExistenceProofBody() {
    }

    @Generated
    public ExistenceProofBody(LedgerKey[] keysToProve, ColdArchiveBucketEntry[] lowBoundEntries, ColdArchiveBucketEntry[] highBoundEntries, ProofLevel[] proofLevels) {
        this.keysToProve = keysToProve;
        this.lowBoundEntries = lowBoundEntries;
        this.highBoundEntries = highBoundEntries;
        this.proofLevels = proofLevels;
    }

    @Generated
    public static class ExistenceProofBodyBuilder {
        @Generated
        private LedgerKey[] keysToProve;
        @Generated
        private ColdArchiveBucketEntry[] lowBoundEntries;
        @Generated
        private ColdArchiveBucketEntry[] highBoundEntries;
        @Generated
        private ProofLevel[] proofLevels;

        @Generated
        ExistenceProofBodyBuilder() {
        }

        @Generated
        public ExistenceProofBodyBuilder keysToProve(LedgerKey[] keysToProve) {
            this.keysToProve = keysToProve;
            return this;
        }

        @Generated
        public ExistenceProofBodyBuilder lowBoundEntries(ColdArchiveBucketEntry[] lowBoundEntries) {
            this.lowBoundEntries = lowBoundEntries;
            return this;
        }

        @Generated
        public ExistenceProofBodyBuilder highBoundEntries(ColdArchiveBucketEntry[] highBoundEntries) {
            this.highBoundEntries = highBoundEntries;
            return this;
        }

        @Generated
        public ExistenceProofBodyBuilder proofLevels(ProofLevel[] proofLevels) {
            this.proofLevels = proofLevels;
            return this;
        }

        @Generated
        public ExistenceProofBody build() {
            return new ExistenceProofBody(this.keysToProve, this.lowBoundEntries, this.highBoundEntries, this.proofLevels);
        }

        @Generated
        public String toString() {
            return "ExistenceProofBody.ExistenceProofBodyBuilder(keysToProve=" + Arrays.deepToString(this.keysToProve) + ", lowBoundEntries=" + Arrays.deepToString(this.lowBoundEntries) + ", highBoundEntries=" + Arrays.deepToString(this.highBoundEntries) + ", proofLevels=" + Arrays.deepToString(this.proofLevels) + ")";
        }
    }
}

