/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCPHistoryEntryV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPHistoryEntry
implements XdrElement {
    private Integer discriminant;
    private SCPHistoryEntryV0 v0;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant);
        switch (this.discriminant) {
            case 0: {
                this.v0.encode(stream);
            }
        }
    }

    public static SCPHistoryEntry decode(XdrDataInputStream stream) throws IOException {
        SCPHistoryEntry decodedSCPHistoryEntry = new SCPHistoryEntry();
        Integer discriminant = stream.readInt();
        decodedSCPHistoryEntry.setDiscriminant(discriminant);
        switch (decodedSCPHistoryEntry.getDiscriminant()) {
            case 0: {
                decodedSCPHistoryEntry.v0 = SCPHistoryEntryV0.decode(stream);
            }
        }
        return decodedSCPHistoryEntry;
    }

    public static SCPHistoryEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPHistoryEntry.fromXdrByteArray(bytes);
    }

    public static SCPHistoryEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPHistoryEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static SCPHistoryEntryBuilder builder() {
        return new SCPHistoryEntryBuilder();
    }

    @Generated
    public SCPHistoryEntryBuilder toBuilder() {
        return new SCPHistoryEntryBuilder().discriminant(this.discriminant).v0(this.v0);
    }

    @Generated
    public Integer getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public SCPHistoryEntryV0 getV0() {
        return this.v0;
    }

    @Generated
    public void setDiscriminant(Integer discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setV0(SCPHistoryEntryV0 v0) {
        this.v0 = v0;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCPHistoryEntry)) {
            return false;
        }
        SCPHistoryEntry other = (SCPHistoryEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$discriminant = this.getDiscriminant();
        Integer other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
            return false;
        }
        SCPHistoryEntryV0 this$v0 = this.getV0();
        SCPHistoryEntryV0 other$v0 = other.getV0();
        return !(this$v0 == null ? other$v0 != null : !((Object)this$v0).equals(other$v0));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCPHistoryEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
        SCPHistoryEntryV0 $v0 = this.getV0();
        result = result * 59 + ($v0 == null ? 43 : ((Object)$v0).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCPHistoryEntry(discriminant=" + this.getDiscriminant() + ", v0=" + this.getV0() + ")";
    }

    @Generated
    public SCPHistoryEntry() {
    }

    @Generated
    public SCPHistoryEntry(Integer discriminant, SCPHistoryEntryV0 v0) {
        this.discriminant = discriminant;
        this.v0 = v0;
    }

    @Generated
    public static class SCPHistoryEntryBuilder {
        @Generated
        private Integer discriminant;
        @Generated
        private SCPHistoryEntryV0 v0;

        @Generated
        SCPHistoryEntryBuilder() {
        }

        @Generated
        public SCPHistoryEntryBuilder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCPHistoryEntryBuilder v0(SCPHistoryEntryV0 v0) {
            this.v0 = v0;
            return this;
        }

        @Generated
        public SCPHistoryEntry build() {
            return new SCPHistoryEntry(this.discriminant, this.v0);
        }

        @Generated
        public String toString() {
            return "SCPHistoryEntry.SCPHistoryEntryBuilder(discriminant=" + this.discriminant + ", v0=" + this.v0 + ")";
        }
    }
}

