/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.StellarValue;
import org.stellar.sdk.xdr.StoredTransactionSet;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class StoredDebugTransactionSet
implements XdrElement {
    private StoredTransactionSet txSet;
    private Uint32 ledgerSeq;
    private StellarValue scpValue;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.txSet.encode(stream);
        this.ledgerSeq.encode(stream);
        this.scpValue.encode(stream);
    }

    public static StoredDebugTransactionSet decode(XdrDataInputStream stream) throws IOException {
        StoredDebugTransactionSet decodedStoredDebugTransactionSet = new StoredDebugTransactionSet();
        decodedStoredDebugTransactionSet.txSet = StoredTransactionSet.decode(stream);
        decodedStoredDebugTransactionSet.ledgerSeq = Uint32.decode(stream);
        decodedStoredDebugTransactionSet.scpValue = StellarValue.decode(stream);
        return decodedStoredDebugTransactionSet;
    }

    public static StoredDebugTransactionSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return StoredDebugTransactionSet.fromXdrByteArray(bytes);
    }

    public static StoredDebugTransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return StoredDebugTransactionSet.decode(xdrDataInputStream);
    }

    @Generated
    public static StoredDebugTransactionSetBuilder builder() {
        return new StoredDebugTransactionSetBuilder();
    }

    @Generated
    public StoredDebugTransactionSetBuilder toBuilder() {
        return new StoredDebugTransactionSetBuilder().txSet(this.txSet).ledgerSeq(this.ledgerSeq).scpValue(this.scpValue);
    }

    @Generated
    public StoredTransactionSet getTxSet() {
        return this.txSet;
    }

    @Generated
    public Uint32 getLedgerSeq() {
        return this.ledgerSeq;
    }

    @Generated
    public StellarValue getScpValue() {
        return this.scpValue;
    }

    @Generated
    public void setTxSet(StoredTransactionSet txSet) {
        this.txSet = txSet;
    }

    @Generated
    public void setLedgerSeq(Uint32 ledgerSeq) {
        this.ledgerSeq = ledgerSeq;
    }

    @Generated
    public void setScpValue(StellarValue scpValue) {
        this.scpValue = scpValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoredDebugTransactionSet)) {
            return false;
        }
        StoredDebugTransactionSet other = (StoredDebugTransactionSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StoredTransactionSet this$txSet = this.getTxSet();
        StoredTransactionSet other$txSet = other.getTxSet();
        if (this$txSet == null ? other$txSet != null : !((Object)this$txSet).equals(other$txSet)) {
            return false;
        }
        Uint32 this$ledgerSeq = this.getLedgerSeq();
        Uint32 other$ledgerSeq = other.getLedgerSeq();
        if (this$ledgerSeq == null ? other$ledgerSeq != null : !((Object)this$ledgerSeq).equals(other$ledgerSeq)) {
            return false;
        }
        StellarValue this$scpValue = this.getScpValue();
        StellarValue other$scpValue = other.getScpValue();
        return !(this$scpValue == null ? other$scpValue != null : !((Object)this$scpValue).equals(other$scpValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StoredDebugTransactionSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StoredTransactionSet $txSet = this.getTxSet();
        result = result * 59 + ($txSet == null ? 43 : ((Object)$txSet).hashCode());
        Uint32 $ledgerSeq = this.getLedgerSeq();
        result = result * 59 + ($ledgerSeq == null ? 43 : ((Object)$ledgerSeq).hashCode());
        StellarValue $scpValue = this.getScpValue();
        result = result * 59 + ($scpValue == null ? 43 : ((Object)$scpValue).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StoredDebugTransactionSet(txSet=" + this.getTxSet() + ", ledgerSeq=" + this.getLedgerSeq() + ", scpValue=" + this.getScpValue() + ")";
    }

    @Generated
    public StoredDebugTransactionSet() {
    }

    @Generated
    public StoredDebugTransactionSet(StoredTransactionSet txSet, Uint32 ledgerSeq, StellarValue scpValue) {
        this.txSet = txSet;
        this.ledgerSeq = ledgerSeq;
        this.scpValue = scpValue;
    }

    @Generated
    public static class StoredDebugTransactionSetBuilder {
        @Generated
        private StoredTransactionSet txSet;
        @Generated
        private Uint32 ledgerSeq;
        @Generated
        private StellarValue scpValue;

        @Generated
        StoredDebugTransactionSetBuilder() {
        }

        @Generated
        public StoredDebugTransactionSetBuilder txSet(StoredTransactionSet txSet) {
            this.txSet = txSet;
            return this;
        }

        @Generated
        public StoredDebugTransactionSetBuilder ledgerSeq(Uint32 ledgerSeq) {
            this.ledgerSeq = ledgerSeq;
            return this;
        }

        @Generated
        public StoredDebugTransactionSetBuilder scpValue(StellarValue scpValue) {
            this.scpValue = scpValue;
            return this;
        }

        @Generated
        public StoredDebugTransactionSet build() {
            return new StoredDebugTransactionSet(this.txSet, this.ledgerSeq, this.scpValue);
        }

        @Generated
        public String toString() {
            return "StoredDebugTransactionSet.StoredDebugTransactionSetBuilder(txSet=" + this.txSet + ", ledgerSeq=" + this.ledgerSeq + ", scpValue=" + this.scpValue + ")";
        }
    }
}

