/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.InnerTransactionResultPair;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.OperationResult;
import org.stellar.sdk.xdr.TransactionResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionResult
implements XdrElement {
    private Int64 feeCharged;
    private TransactionResultResult result;
    private TransactionResultExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.feeCharged.encode(stream);
        this.result.encode(stream);
        this.ext.encode(stream);
    }

    public static TransactionResult decode(XdrDataInputStream stream) throws IOException {
        TransactionResult decodedTransactionResult = new TransactionResult();
        decodedTransactionResult.feeCharged = Int64.decode(stream);
        decodedTransactionResult.result = TransactionResultResult.decode(stream);
        decodedTransactionResult.ext = TransactionResultExt.decode(stream);
        return decodedTransactionResult;
    }

    public static TransactionResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionResult.fromXdrByteArray(bytes);
    }

    public static TransactionResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionResult.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionResultBuilder builder() {
        return new TransactionResultBuilder();
    }

    @Generated
    public TransactionResultBuilder toBuilder() {
        return new TransactionResultBuilder().feeCharged(this.feeCharged).result(this.result).ext(this.ext);
    }

    @Generated
    public Int64 getFeeCharged() {
        return this.feeCharged;
    }

    @Generated
    public TransactionResultResult getResult() {
        return this.result;
    }

    @Generated
    public TransactionResultExt getExt() {
        return this.ext;
    }

    @Generated
    public void setFeeCharged(Int64 feeCharged) {
        this.feeCharged = feeCharged;
    }

    @Generated
    public void setResult(TransactionResultResult result) {
        this.result = result;
    }

    @Generated
    public void setExt(TransactionResultExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionResult)) {
            return false;
        }
        TransactionResult other = (TransactionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Int64 this$feeCharged = this.getFeeCharged();
        Int64 other$feeCharged = other.getFeeCharged();
        if (this$feeCharged == null ? other$feeCharged != null : !((Object)this$feeCharged).equals(other$feeCharged)) {
            return false;
        }
        TransactionResultResult this$result = this.getResult();
        TransactionResultResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        TransactionResultExt this$ext = this.getExt();
        TransactionResultExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Int64 $feeCharged = this.getFeeCharged();
        result = result * 59 + ($feeCharged == null ? 43 : ((Object)$feeCharged).hashCode());
        TransactionResultResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        TransactionResultExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionResult(feeCharged=" + this.getFeeCharged() + ", result=" + this.getResult() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public TransactionResult() {
    }

    @Generated
    public TransactionResult(Int64 feeCharged, TransactionResultResult result, TransactionResultExt ext) {
        this.feeCharged = feeCharged;
        this.result = result;
        this.ext = ext;
    }

    public static class TransactionResultResult
    implements XdrElement {
        private TransactionResultCode discriminant;
        private InnerTransactionResultPair innerResultPair;
        private OperationResult[] results;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case txFEE_BUMP_INNER_SUCCESS: 
                case txFEE_BUMP_INNER_FAILED: {
                    this.innerResultPair.encode(stream);
                    break;
                }
                case txSUCCESS: 
                case txFAILED: {
                    int resultsSize = this.getResults().length;
                    stream.writeInt(resultsSize);
                    for (int i = 0; i < resultsSize; ++i) {
                        this.results[i].encode(stream);
                    }
                    break;
                }
            }
        }

        public static TransactionResultResult decode(XdrDataInputStream stream) throws IOException {
            TransactionResultResult decodedTransactionResultResult = new TransactionResultResult();
            TransactionResultCode discriminant = TransactionResultCode.decode(stream);
            decodedTransactionResultResult.setDiscriminant(discriminant);
            switch (decodedTransactionResultResult.getDiscriminant()) {
                case txFEE_BUMP_INNER_SUCCESS: 
                case txFEE_BUMP_INNER_FAILED: {
                    decodedTransactionResultResult.innerResultPair = InnerTransactionResultPair.decode(stream);
                    break;
                }
                case txSUCCESS: 
                case txFAILED: {
                    int resultsSize = stream.readInt();
                    decodedTransactionResultResult.results = new OperationResult[resultsSize];
                    for (int i = 0; i < resultsSize; ++i) {
                        decodedTransactionResultResult.results[i] = OperationResult.decode(stream);
                    }
                    break;
                }
            }
            return decodedTransactionResultResult;
        }

        public static TransactionResultResult fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TransactionResultResult.fromXdrByteArray(bytes);
        }

        public static TransactionResultResult fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TransactionResultResult.decode(xdrDataInputStream);
        }

        @Generated
        public static TransactionResultResultBuilder builder() {
            return new TransactionResultResultBuilder();
        }

        @Generated
        public TransactionResultResultBuilder toBuilder() {
            return new TransactionResultResultBuilder().discriminant(this.discriminant).innerResultPair(this.innerResultPair).results(this.results);
        }

        @Generated
        public TransactionResultCode getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public InnerTransactionResultPair getInnerResultPair() {
            return this.innerResultPair;
        }

        @Generated
        public OperationResult[] getResults() {
            return this.results;
        }

        @Generated
        public void setDiscriminant(TransactionResultCode discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setInnerResultPair(InnerTransactionResultPair innerResultPair) {
            this.innerResultPair = innerResultPair;
        }

        @Generated
        public void setResults(OperationResult[] results) {
            this.results = results;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionResultResult)) {
                return false;
            }
            TransactionResultResult other = (TransactionResultResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TransactionResultCode this$discriminant = this.getDiscriminant();
            TransactionResultCode other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            InnerTransactionResultPair this$innerResultPair = this.getInnerResultPair();
            InnerTransactionResultPair other$innerResultPair = other.getInnerResultPair();
            if (this$innerResultPair == null ? other$innerResultPair != null : !((Object)this$innerResultPair).equals(other$innerResultPair)) {
                return false;
            }
            return Arrays.deepEquals(this.getResults(), other.getResults());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionResultResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TransactionResultCode $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            InnerTransactionResultPair $innerResultPair = this.getInnerResultPair();
            result = result * 59 + ($innerResultPair == null ? 43 : ((Object)$innerResultPair).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getResults());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionResult.TransactionResultResult(discriminant=" + this.getDiscriminant() + ", innerResultPair=" + this.getInnerResultPair() + ", results=" + Arrays.deepToString(this.getResults()) + ")";
        }

        @Generated
        public TransactionResultResult() {
        }

        @Generated
        public TransactionResultResult(TransactionResultCode discriminant, InnerTransactionResultPair innerResultPair, OperationResult[] results) {
            this.discriminant = discriminant;
            this.innerResultPair = innerResultPair;
            this.results = results;
        }

        @Generated
        public static class TransactionResultResultBuilder {
            @Generated
            private TransactionResultCode discriminant;
            @Generated
            private InnerTransactionResultPair innerResultPair;
            @Generated
            private OperationResult[] results;

            @Generated
            TransactionResultResultBuilder() {
            }

            @Generated
            public TransactionResultResultBuilder discriminant(TransactionResultCode discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public TransactionResultResultBuilder innerResultPair(InnerTransactionResultPair innerResultPair) {
                this.innerResultPair = innerResultPair;
                return this;
            }

            @Generated
            public TransactionResultResultBuilder results(OperationResult[] results) {
                this.results = results;
                return this;
            }

            @Generated
            public TransactionResultResult build() {
                return new TransactionResultResult(this.discriminant, this.innerResultPair, this.results);
            }

            @Generated
            public String toString() {
                return "TransactionResult.TransactionResultResult.TransactionResultResultBuilder(discriminant=" + this.discriminant + ", innerResultPair=" + this.innerResultPair + ", results=" + Arrays.deepToString(this.results) + ")";
            }
        }
    }

    public static class TransactionResultExt
    implements XdrElement {
        private Integer discriminant;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                default: 
            }
        }

        public static TransactionResultExt decode(XdrDataInputStream stream) throws IOException {
            TransactionResultExt decodedTransactionResultExt = new TransactionResultExt();
            Integer discriminant = stream.readInt();
            decodedTransactionResultExt.setDiscriminant(discriminant);
            switch (decodedTransactionResultExt.getDiscriminant()) {
                default: 
            }
            return decodedTransactionResultExt;
        }

        public static TransactionResultExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TransactionResultExt.fromXdrByteArray(bytes);
        }

        public static TransactionResultExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TransactionResultExt.decode(xdrDataInputStream);
        }

        @Generated
        public static TransactionResultExtBuilder builder() {
            return new TransactionResultExtBuilder();
        }

        @Generated
        public TransactionResultExtBuilder toBuilder() {
            return new TransactionResultExtBuilder().discriminant(this.discriminant);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionResultExt)) {
                return false;
            }
            TransactionResultExt other = (TransactionResultExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            return !(this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionResultExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionResult.TransactionResultExt(discriminant=" + this.getDiscriminant() + ")";
        }

        @Generated
        public TransactionResultExt() {
        }

        @Generated
        public TransactionResultExt(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public static class TransactionResultExtBuilder {
            @Generated
            private Integer discriminant;

            @Generated
            TransactionResultExtBuilder() {
            }

            @Generated
            public TransactionResultExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public TransactionResultExt build() {
                return new TransactionResultExt(this.discriminant);
            }

            @Generated
            public String toString() {
                return "TransactionResult.TransactionResultExt.TransactionResultExtBuilder(discriminant=" + this.discriminant + ")";
            }
        }
    }

    @Generated
    public static class TransactionResultBuilder {
        @Generated
        private Int64 feeCharged;
        @Generated
        private TransactionResultResult result;
        @Generated
        private TransactionResultExt ext;

        @Generated
        TransactionResultBuilder() {
        }

        @Generated
        public TransactionResultBuilder feeCharged(Int64 feeCharged) {
            this.feeCharged = feeCharged;
            return this;
        }

        @Generated
        public TransactionResultBuilder result(TransactionResultResult result) {
            this.result = result;
            return this;
        }

        @Generated
        public TransactionResultBuilder ext(TransactionResultExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public TransactionResult build() {
            return new TransactionResult(this.feeCharged, this.result, this.ext);
        }

        @Generated
        public String toString() {
            return "TransactionResult.TransactionResultBuilder(feeCharged=" + this.feeCharged + ", result=" + this.result + ", ext=" + this.ext + ")";
        }
    }
}

