/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerFootprint;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SorobanResources;
import org.stellar.sdk.xdr.SorobanTransactionData;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class SorobanDataBuilder {
    private final SorobanTransactionData data;

    public SorobanDataBuilder() {
        this.data = SorobanTransactionData.builder().resources(SorobanResources.builder().footprint(LedgerFootprint.builder().readOnly(new LedgerKey[0]).readWrite(new LedgerKey[0]).build()).instructions(new Uint32(new XdrUnsignedInteger(0))).readBytes(new Uint32(new XdrUnsignedInteger(0))).writeBytes(new Uint32(new XdrUnsignedInteger(0))).build()).resourceFee(new Int64(0L)).ext(ExtensionPoint.builder().discriminant(0).build()).build();
    }

    public SorobanDataBuilder(String sorobanData) {
        try {
            this.data = SorobanTransactionData.fromXdrBase64(sorobanData);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid SorobanData: " + sorobanData, e);
        }
    }

    public SorobanDataBuilder(SorobanTransactionData sorobanData) {
        try {
            this.data = SorobanTransactionData.fromXdrByteArray(sorobanData.toXdrByteArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid SorobanData: " + sorobanData, e);
        }
    }

    public SorobanDataBuilder setResourceFee(long fee) {
        this.data.setResourceFee(new Int64(fee));
        return this;
    }

    public SorobanDataBuilder setResources(Resources resources) {
        this.data.getResources().setInstructions(new Uint32(new XdrUnsignedInteger(resources.getCpuInstructions())));
        this.data.getResources().setReadBytes(new Uint32(new XdrUnsignedInteger(resources.getReadBytes())));
        this.data.getResources().setWriteBytes(new Uint32(new XdrUnsignedInteger(resources.getWriteBytes())));
        return this;
    }

    public SorobanDataBuilder setReadOnly(@Nullable Collection<LedgerKey> readOnly) {
        if (readOnly != null) {
            this.data.getResources().getFootprint().setReadOnly(readOnly.toArray(new LedgerKey[0]));
        }
        return this;
    }

    public SorobanDataBuilder setReadWrite(@Nullable Collection<LedgerKey> readWrite) {
        if (readWrite != null) {
            this.data.getResources().getFootprint().setReadWrite(readWrite.toArray(new LedgerKey[0]));
        }
        return this;
    }

    public SorobanTransactionData build() {
        try {
            return SorobanTransactionData.fromXdrByteArray(this.data.toXdrByteArray());
        }
        catch (IOException e) {
            throw new UnexpectedException("Copy SorobanData failed, please report this bug.", e);
        }
    }

    public static final class Resources {
        @NonNull
        private final Long cpuInstructions;
        @NonNull
        private final Long readBytes;
        @NonNull
        private final Long writeBytes;

        @Generated
        Resources(@NonNull Long cpuInstructions, @NonNull Long readBytes, @NonNull Long writeBytes) {
            if (cpuInstructions == null) {
                throw new NullPointerException("cpuInstructions is marked non-null but is null");
            }
            if (readBytes == null) {
                throw new NullPointerException("readBytes is marked non-null but is null");
            }
            if (writeBytes == null) {
                throw new NullPointerException("writeBytes is marked non-null but is null");
            }
            this.cpuInstructions = cpuInstructions;
            this.readBytes = readBytes;
            this.writeBytes = writeBytes;
        }

        @Generated
        public static ResourcesBuilder builder() {
            return new ResourcesBuilder();
        }

        @Generated
        public ResourcesBuilder toBuilder() {
            return new ResourcesBuilder().cpuInstructions(this.cpuInstructions).readBytes(this.readBytes).writeBytes(this.writeBytes);
        }

        @NonNull
        @Generated
        public Long getCpuInstructions() {
            return this.cpuInstructions;
        }

        @NonNull
        @Generated
        public Long getReadBytes() {
            return this.readBytes;
        }

        @NonNull
        @Generated
        public Long getWriteBytes() {
            return this.writeBytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resources)) {
                return false;
            }
            Resources other = (Resources)o;
            Long this$cpuInstructions = this.getCpuInstructions();
            Long other$cpuInstructions = other.getCpuInstructions();
            if (this$cpuInstructions == null ? other$cpuInstructions != null : !((Object)this$cpuInstructions).equals(other$cpuInstructions)) {
                return false;
            }
            Long this$readBytes = this.getReadBytes();
            Long other$readBytes = other.getReadBytes();
            if (this$readBytes == null ? other$readBytes != null : !((Object)this$readBytes).equals(other$readBytes)) {
                return false;
            }
            Long this$writeBytes = this.getWriteBytes();
            Long other$writeBytes = other.getWriteBytes();
            return !(this$writeBytes == null ? other$writeBytes != null : !((Object)this$writeBytes).equals(other$writeBytes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $cpuInstructions = this.getCpuInstructions();
            result = result * 59 + ($cpuInstructions == null ? 43 : ((Object)$cpuInstructions).hashCode());
            Long $readBytes = this.getReadBytes();
            result = result * 59 + ($readBytes == null ? 43 : ((Object)$readBytes).hashCode());
            Long $writeBytes = this.getWriteBytes();
            result = result * 59 + ($writeBytes == null ? 43 : ((Object)$writeBytes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SorobanDataBuilder.Resources(cpuInstructions=" + this.getCpuInstructions() + ", readBytes=" + this.getReadBytes() + ", writeBytes=" + this.getWriteBytes() + ")";
        }

        @Generated
        public static class ResourcesBuilder {
            @Generated
            private Long cpuInstructions;
            @Generated
            private Long readBytes;
            @Generated
            private Long writeBytes;

            @Generated
            ResourcesBuilder() {
            }

            @Generated
            public ResourcesBuilder cpuInstructions(@NonNull Long cpuInstructions) {
                if (cpuInstructions == null) {
                    throw new NullPointerException("cpuInstructions is marked non-null but is null");
                }
                this.cpuInstructions = cpuInstructions;
                return this;
            }

            @Generated
            public ResourcesBuilder readBytes(@NonNull Long readBytes) {
                if (readBytes == null) {
                    throw new NullPointerException("readBytes is marked non-null but is null");
                }
                this.readBytes = readBytes;
                return this;
            }

            @Generated
            public ResourcesBuilder writeBytes(@NonNull Long writeBytes) {
                if (writeBytes == null) {
                    throw new NullPointerException("writeBytes is marked non-null but is null");
                }
                this.writeBytes = writeBytes;
                return this;
            }

            @Generated
            public Resources build() {
                return new Resources(this.cpuInstructions, this.readBytes, this.writeBytes);
            }

            @Generated
            public String toString() {
                return "SorobanDataBuilder.Resources.ResourcesBuilder(cpuInstructions=" + this.cpuInstructions + ", readBytes=" + this.readBytes + ", writeBytes=" + this.writeBytes + ")";
            }
        }
    }
}

