/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.stellar.sdk.Asset;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.responses.OfferResponse;
import org.stellar.sdk.responses.Page;

public class OffersRequestBuilder
extends RequestBuilder {
    public OffersRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "offers");
    }

    public OfferResponse offer(HttpUrl uri) {
        TypeToken<OfferResponse> type = new TypeToken<OfferResponse>(){};
        return OffersRequestBuilder.executeGetRequest(this.httpClient, uri, type);
    }

    public OfferResponse offer(long offerId) {
        this.setSegments("offers", String.valueOf(offerId));
        return this.offer(this.buildUri());
    }

    public OffersRequestBuilder forSponsor(String sponsor) {
        this.uriBuilder.setQueryParameter("sponsor", sponsor);
        return this;
    }

    public OffersRequestBuilder forSeller(String seller) {
        this.uriBuilder.setQueryParameter("seller", seller);
        return this;
    }

    public OffersRequestBuilder forBuyingAsset(Asset asset) {
        this.setAssetParameter("buying", asset);
        return this;
    }

    public OffersRequestBuilder forSellingAsset(Asset asset) {
        this.setAssetParameter("selling", asset);
        return this;
    }

    public static Page<OfferResponse> execute(OkHttpClient httpClient, HttpUrl uri) {
        TypeToken<Page<OfferResponse>> type = new TypeToken<Page<OfferResponse>>(){};
        return OffersRequestBuilder.executeGetRequest(httpClient, uri, type);
    }

    public SSEStream<OfferResponse> stream(EventListener<OfferResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, OfferResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<OfferResponse> stream(EventListener<OfferResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public Page<OfferResponse> execute() {
        return OffersRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public OffersRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public OffersRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public OffersRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

