/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AllowTrustResultCode implements XdrElement
{
    ALLOW_TRUST_SUCCESS(0),
    ALLOW_TRUST_MALFORMED(-1),
    ALLOW_TRUST_NO_TRUST_LINE(-2),
    ALLOW_TRUST_TRUST_NOT_REQUIRED(-3),
    ALLOW_TRUST_CANT_REVOKE(-4),
    ALLOW_TRUST_SELF_NOT_ALLOWED(-5),
    ALLOW_TRUST_LOW_RESERVE(-6);

    private final int value;

    private AllowTrustResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AllowTrustResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ALLOW_TRUST_SUCCESS;
            }
            case -1: {
                return ALLOW_TRUST_MALFORMED;
            }
            case -2: {
                return ALLOW_TRUST_NO_TRUST_LINE;
            }
            case -3: {
                return ALLOW_TRUST_TRUST_NOT_REQUIRED;
            }
            case -4: {
                return ALLOW_TRUST_CANT_REVOKE;
            }
            case -5: {
                return ALLOW_TRUST_SELF_NOT_ALLOWED;
            }
            case -6: {
                return ALLOW_TRUST_LOW_RESERVE;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static AllowTrustResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AllowTrustResultCode.fromXdrByteArray(bytes);
    }

    public static AllowTrustResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AllowTrustResultCode.decode(xdrDataInputStream);
    }
}

