/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Curve25519Public;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AuthCert
implements XdrElement {
    private Curve25519Public pubkey;
    private Uint64 expiration;
    private Signature sig;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.pubkey.encode(stream);
        this.expiration.encode(stream);
        this.sig.encode(stream);
    }

    public static AuthCert decode(XdrDataInputStream stream) throws IOException {
        AuthCert decodedAuthCert = new AuthCert();
        decodedAuthCert.pubkey = Curve25519Public.decode(stream);
        decodedAuthCert.expiration = Uint64.decode(stream);
        decodedAuthCert.sig = Signature.decode(stream);
        return decodedAuthCert;
    }

    public static AuthCert fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AuthCert.fromXdrByteArray(bytes);
    }

    public static AuthCert fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AuthCert.decode(xdrDataInputStream);
    }

    @Generated
    public static AuthCertBuilder builder() {
        return new AuthCertBuilder();
    }

    @Generated
    public AuthCertBuilder toBuilder() {
        return new AuthCertBuilder().pubkey(this.pubkey).expiration(this.expiration).sig(this.sig);
    }

    @Generated
    public Curve25519Public getPubkey() {
        return this.pubkey;
    }

    @Generated
    public Uint64 getExpiration() {
        return this.expiration;
    }

    @Generated
    public Signature getSig() {
        return this.sig;
    }

    @Generated
    public void setPubkey(Curve25519Public pubkey) {
        this.pubkey = pubkey;
    }

    @Generated
    public void setExpiration(Uint64 expiration) {
        this.expiration = expiration;
    }

    @Generated
    public void setSig(Signature sig) {
        this.sig = sig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthCert)) {
            return false;
        }
        AuthCert other = (AuthCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Curve25519Public this$pubkey = this.getPubkey();
        Curve25519Public other$pubkey = other.getPubkey();
        if (this$pubkey == null ? other$pubkey != null : !((Object)this$pubkey).equals(other$pubkey)) {
            return false;
        }
        Uint64 this$expiration = this.getExpiration();
        Uint64 other$expiration = other.getExpiration();
        if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
            return false;
        }
        Signature this$sig = this.getSig();
        Signature other$sig = other.getSig();
        return !(this$sig == null ? other$sig != null : !((Object)this$sig).equals(other$sig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthCert;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Curve25519Public $pubkey = this.getPubkey();
        result = result * 59 + ($pubkey == null ? 43 : ((Object)$pubkey).hashCode());
        Uint64 $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        Signature $sig = this.getSig();
        result = result * 59 + ($sig == null ? 43 : ((Object)$sig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthCert(pubkey=" + this.getPubkey() + ", expiration=" + this.getExpiration() + ", sig=" + this.getSig() + ")";
    }

    @Generated
    public AuthCert() {
    }

    @Generated
    public AuthCert(Curve25519Public pubkey, Uint64 expiration, Signature sig) {
        this.pubkey = pubkey;
        this.expiration = expiration;
        this.sig = sig;
    }

    @Generated
    public static class AuthCertBuilder {
        @Generated
        private Curve25519Public pubkey;
        @Generated
        private Uint64 expiration;
        @Generated
        private Signature sig;

        @Generated
        AuthCertBuilder() {
        }

        @Generated
        public AuthCertBuilder pubkey(Curve25519Public pubkey) {
            this.pubkey = pubkey;
            return this;
        }

        @Generated
        public AuthCertBuilder expiration(Uint64 expiration) {
            this.expiration = expiration;
            return this;
        }

        @Generated
        public AuthCertBuilder sig(Signature sig) {
            this.sig = sig;
            return this;
        }

        @Generated
        public AuthCert build() {
            return new AuthCert(this.pubkey, this.expiration, this.sig);
        }

        @Generated
        public String toString() {
            return "AuthCert.AuthCertBuilder(pubkey=" + this.pubkey + ", expiration=" + this.expiration + ", sig=" + this.sig + ")";
        }
    }
}

