/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ColdArchiveArchivedLeaf
implements XdrElement {
    private Uint32 index;
    private LedgerEntry archivedEntry;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.index.encode(stream);
        this.archivedEntry.encode(stream);
    }

    public static ColdArchiveArchivedLeaf decode(XdrDataInputStream stream) throws IOException {
        ColdArchiveArchivedLeaf decodedColdArchiveArchivedLeaf = new ColdArchiveArchivedLeaf();
        decodedColdArchiveArchivedLeaf.index = Uint32.decode(stream);
        decodedColdArchiveArchivedLeaf.archivedEntry = LedgerEntry.decode(stream);
        return decodedColdArchiveArchivedLeaf;
    }

    public static ColdArchiveArchivedLeaf fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ColdArchiveArchivedLeaf.fromXdrByteArray(bytes);
    }

    public static ColdArchiveArchivedLeaf fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ColdArchiveArchivedLeaf.decode(xdrDataInputStream);
    }

    @Generated
    public static ColdArchiveArchivedLeafBuilder builder() {
        return new ColdArchiveArchivedLeafBuilder();
    }

    @Generated
    public ColdArchiveArchivedLeafBuilder toBuilder() {
        return new ColdArchiveArchivedLeafBuilder().index(this.index).archivedEntry(this.archivedEntry);
    }

    @Generated
    public Uint32 getIndex() {
        return this.index;
    }

    @Generated
    public LedgerEntry getArchivedEntry() {
        return this.archivedEntry;
    }

    @Generated
    public void setIndex(Uint32 index) {
        this.index = index;
    }

    @Generated
    public void setArchivedEntry(LedgerEntry archivedEntry) {
        this.archivedEntry = archivedEntry;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColdArchiveArchivedLeaf)) {
            return false;
        }
        ColdArchiveArchivedLeaf other = (ColdArchiveArchivedLeaf)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$index = this.getIndex();
        Uint32 other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        LedgerEntry this$archivedEntry = this.getArchivedEntry();
        LedgerEntry other$archivedEntry = other.getArchivedEntry();
        return !(this$archivedEntry == null ? other$archivedEntry != null : !((Object)this$archivedEntry).equals(other$archivedEntry));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ColdArchiveArchivedLeaf;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        LedgerEntry $archivedEntry = this.getArchivedEntry();
        result = result * 59 + ($archivedEntry == null ? 43 : ((Object)$archivedEntry).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ColdArchiveArchivedLeaf(index=" + this.getIndex() + ", archivedEntry=" + this.getArchivedEntry() + ")";
    }

    @Generated
    public ColdArchiveArchivedLeaf() {
    }

    @Generated
    public ColdArchiveArchivedLeaf(Uint32 index, LedgerEntry archivedEntry) {
        this.index = index;
        this.archivedEntry = archivedEntry;
    }

    @Generated
    public static class ColdArchiveArchivedLeafBuilder {
        @Generated
        private Uint32 index;
        @Generated
        private LedgerEntry archivedEntry;

        @Generated
        ColdArchiveArchivedLeafBuilder() {
        }

        @Generated
        public ColdArchiveArchivedLeafBuilder index(Uint32 index) {
            this.index = index;
            return this;
        }

        @Generated
        public ColdArchiveArchivedLeafBuilder archivedEntry(LedgerEntry archivedEntry) {
            this.archivedEntry = archivedEntry;
            return this;
        }

        @Generated
        public ColdArchiveArchivedLeaf build() {
            return new ColdArchiveArchivedLeaf(this.index, this.archivedEntry);
        }

        @Generated
        public String toString() {
            return "ColdArchiveArchivedLeaf.ColdArchiveArchivedLeafBuilder(index=" + this.index + ", archivedEntry=" + this.archivedEntry + ")";
        }
    }
}

