/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ColdArchiveBucketEntryType implements XdrElement
{
    COLD_ARCHIVE_METAENTRY(-1),
    COLD_ARCHIVE_ARCHIVED_LEAF(0),
    COLD_ARCHIVE_DELETED_LEAF(1),
    COLD_ARCHIVE_BOUNDARY_LEAF(2),
    COLD_ARCHIVE_HASH(3);

    private final int value;

    private ColdArchiveBucketEntryType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ColdArchiveBucketEntryType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case -1: {
                return COLD_ARCHIVE_METAENTRY;
            }
            case 0: {
                return COLD_ARCHIVE_ARCHIVED_LEAF;
            }
            case 1: {
                return COLD_ARCHIVE_DELETED_LEAF;
            }
            case 2: {
                return COLD_ARCHIVE_BOUNDARY_LEAF;
            }
            case 3: {
                return COLD_ARCHIVE_HASH;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ColdArchiveBucketEntryType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ColdArchiveBucketEntryType.fromXdrByteArray(bytes);
    }

    public static ColdArchiveBucketEntryType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ColdArchiveBucketEntryType.decode(xdrDataInputStream);
    }
}

