/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Curve25519Public
implements XdrElement {
    private byte[] key;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int keySize = this.key.length;
        stream.write(this.getKey(), 0, keySize);
    }

    public static Curve25519Public decode(XdrDataInputStream stream) throws IOException {
        Curve25519Public decodedCurve25519Public = new Curve25519Public();
        int keySize = 32;
        decodedCurve25519Public.key = new byte[keySize];
        stream.read(decodedCurve25519Public.key, 0, keySize);
        return decodedCurve25519Public;
    }

    public static Curve25519Public fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Curve25519Public.fromXdrByteArray(bytes);
    }

    public static Curve25519Public fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Curve25519Public.decode(xdrDataInputStream);
    }

    @Generated
    public static Curve25519PublicBuilder builder() {
        return new Curve25519PublicBuilder();
    }

    @Generated
    public Curve25519PublicBuilder toBuilder() {
        return new Curve25519PublicBuilder().key(this.key);
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @Generated
    public void setKey(byte[] key) {
        this.key = key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Curve25519Public)) {
            return false;
        }
        Curve25519Public other = (Curve25519Public)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getKey(), other.getKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Curve25519Public;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getKey());
        return result;
    }

    @Generated
    public String toString() {
        return "Curve25519Public(key=" + Arrays.toString(this.getKey()) + ")";
    }

    @Generated
    public Curve25519Public() {
    }

    @Generated
    public Curve25519Public(byte[] key) {
        this.key = key;
    }

    @Generated
    public static class Curve25519PublicBuilder {
        @Generated
        private byte[] key;

        @Generated
        Curve25519PublicBuilder() {
        }

        @Generated
        public Curve25519PublicBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        @Generated
        public Curve25519Public build() {
            return new Curve25519Public(this.key);
        }

        @Generated
        public String toString() {
            return "Curve25519Public.Curve25519PublicBuilder(key=" + Arrays.toString(this.key) + ")";
        }
    }
}

