/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerCloseValueSignature
implements XdrElement {
    private NodeID nodeID;
    private Signature signature;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.nodeID.encode(stream);
        this.signature.encode(stream);
    }

    public static LedgerCloseValueSignature decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseValueSignature decodedLedgerCloseValueSignature = new LedgerCloseValueSignature();
        decodedLedgerCloseValueSignature.nodeID = NodeID.decode(stream);
        decodedLedgerCloseValueSignature.signature = Signature.decode(stream);
        return decodedLedgerCloseValueSignature;
    }

    public static LedgerCloseValueSignature fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerCloseValueSignature.fromXdrByteArray(bytes);
    }

    public static LedgerCloseValueSignature fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerCloseValueSignature.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerCloseValueSignatureBuilder builder() {
        return new LedgerCloseValueSignatureBuilder();
    }

    @Generated
    public LedgerCloseValueSignatureBuilder toBuilder() {
        return new LedgerCloseValueSignatureBuilder().nodeID(this.nodeID).signature(this.signature);
    }

    @Generated
    public NodeID getNodeID() {
        return this.nodeID;
    }

    @Generated
    public Signature getSignature() {
        return this.signature;
    }

    @Generated
    public void setNodeID(NodeID nodeID) {
        this.nodeID = nodeID;
    }

    @Generated
    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerCloseValueSignature)) {
            return false;
        }
        LedgerCloseValueSignature other = (LedgerCloseValueSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeID this$nodeID = this.getNodeID();
        NodeID other$nodeID = other.getNodeID();
        if (this$nodeID == null ? other$nodeID != null : !((Object)this$nodeID).equals(other$nodeID)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerCloseValueSignature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeID $nodeID = this.getNodeID();
        result = result * 59 + ($nodeID == null ? 43 : ((Object)$nodeID).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerCloseValueSignature(nodeID=" + this.getNodeID() + ", signature=" + this.getSignature() + ")";
    }

    @Generated
    public LedgerCloseValueSignature() {
    }

    @Generated
    public LedgerCloseValueSignature(NodeID nodeID, Signature signature) {
        this.nodeID = nodeID;
        this.signature = signature;
    }

    @Generated
    public static class LedgerCloseValueSignatureBuilder {
        @Generated
        private NodeID nodeID;
        @Generated
        private Signature signature;

        @Generated
        LedgerCloseValueSignatureBuilder() {
        }

        @Generated
        public LedgerCloseValueSignatureBuilder nodeID(NodeID nodeID) {
            this.nodeID = nodeID;
            return this;
        }

        @Generated
        public LedgerCloseValueSignatureBuilder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        @Generated
        public LedgerCloseValueSignature build() {
            return new LedgerCloseValueSignature(this.nodeID, this.signature);
        }

        @Generated
        public String toString() {
            return "LedgerCloseValueSignature.LedgerCloseValueSignatureBuilder(nodeID=" + this.nodeID + ", signature=" + this.signature + ")";
        }
    }
}

