/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LiquidityPoolDepositResultCode implements XdrElement
{
    LIQUIDITY_POOL_DEPOSIT_SUCCESS(0),
    LIQUIDITY_POOL_DEPOSIT_MALFORMED(-1),
    LIQUIDITY_POOL_DEPOSIT_NO_TRUST(-2),
    LIQUIDITY_POOL_DEPOSIT_NOT_AUTHORIZED(-3),
    LIQUIDITY_POOL_DEPOSIT_UNDERFUNDED(-4),
    LIQUIDITY_POOL_DEPOSIT_LINE_FULL(-5),
    LIQUIDITY_POOL_DEPOSIT_BAD_PRICE(-6),
    LIQUIDITY_POOL_DEPOSIT_POOL_FULL(-7);

    private final int value;

    private LiquidityPoolDepositResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LiquidityPoolDepositResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return LIQUIDITY_POOL_DEPOSIT_SUCCESS;
            }
            case -1: {
                return LIQUIDITY_POOL_DEPOSIT_MALFORMED;
            }
            case -2: {
                return LIQUIDITY_POOL_DEPOSIT_NO_TRUST;
            }
            case -3: {
                return LIQUIDITY_POOL_DEPOSIT_NOT_AUTHORIZED;
            }
            case -4: {
                return LIQUIDITY_POOL_DEPOSIT_UNDERFUNDED;
            }
            case -5: {
                return LIQUIDITY_POOL_DEPOSIT_LINE_FULL;
            }
            case -6: {
                return LIQUIDITY_POOL_DEPOSIT_BAD_PRICE;
            }
            case -7: {
                return LIQUIDITY_POOL_DEPOSIT_POOL_FULL;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static LiquidityPoolDepositResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolDepositResultCode.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolDepositResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolDepositResultCode.decode(xdrDataInputStream);
    }
}

