/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LiquidityPoolParameters
implements XdrElement {
    private LiquidityPoolType discriminant;
    private LiquidityPoolConstantProductParameters constantProduct;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                this.constantProduct.encode(stream);
            }
        }
    }

    public static LiquidityPoolParameters decode(XdrDataInputStream stream) throws IOException {
        LiquidityPoolParameters decodedLiquidityPoolParameters = new LiquidityPoolParameters();
        LiquidityPoolType discriminant = LiquidityPoolType.decode(stream);
        decodedLiquidityPoolParameters.setDiscriminant(discriminant);
        switch (decodedLiquidityPoolParameters.getDiscriminant()) {
            case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                decodedLiquidityPoolParameters.constantProduct = LiquidityPoolConstantProductParameters.decode(stream);
            }
        }
        return decodedLiquidityPoolParameters;
    }

    public static LiquidityPoolParameters fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolParameters.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolParameters fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolParameters.decode(xdrDataInputStream);
    }

    @Generated
    public static LiquidityPoolParametersBuilder builder() {
        return new LiquidityPoolParametersBuilder();
    }

    @Generated
    public LiquidityPoolParametersBuilder toBuilder() {
        return new LiquidityPoolParametersBuilder().discriminant(this.discriminant).constantProduct(this.constantProduct);
    }

    @Generated
    public LiquidityPoolType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public LiquidityPoolConstantProductParameters getConstantProduct() {
        return this.constantProduct;
    }

    @Generated
    public void setDiscriminant(LiquidityPoolType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setConstantProduct(LiquidityPoolConstantProductParameters constantProduct) {
        this.constantProduct = constantProduct;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolParameters)) {
            return false;
        }
        LiquidityPoolParameters other = (LiquidityPoolParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LiquidityPoolType this$discriminant = this.getDiscriminant();
        LiquidityPoolType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        LiquidityPoolConstantProductParameters this$constantProduct = this.getConstantProduct();
        LiquidityPoolConstantProductParameters other$constantProduct = other.getConstantProduct();
        return !(this$constantProduct == null ? other$constantProduct != null : !((Object)this$constantProduct).equals(other$constantProduct));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LiquidityPoolType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        LiquidityPoolConstantProductParameters $constantProduct = this.getConstantProduct();
        result = result * 59 + ($constantProduct == null ? 43 : ((Object)$constantProduct).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LiquidityPoolParameters(discriminant=" + this.getDiscriminant() + ", constantProduct=" + this.getConstantProduct() + ")";
    }

    @Generated
    public LiquidityPoolParameters() {
    }

    @Generated
    public LiquidityPoolParameters(LiquidityPoolType discriminant, LiquidityPoolConstantProductParameters constantProduct) {
        this.discriminant = discriminant;
        this.constantProduct = constantProduct;
    }

    @Generated
    public static class LiquidityPoolParametersBuilder {
        @Generated
        private LiquidityPoolType discriminant;
        @Generated
        private LiquidityPoolConstantProductParameters constantProduct;

        @Generated
        LiquidityPoolParametersBuilder() {
        }

        @Generated
        public LiquidityPoolParametersBuilder discriminant(LiquidityPoolType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public LiquidityPoolParametersBuilder constantProduct(LiquidityPoolConstantProductParameters constantProduct) {
            this.constantProduct = constantProduct;
            return this;
        }

        @Generated
        public LiquidityPoolParameters build() {
            return new LiquidityPoolParameters(this.discriminant, this.constantProduct);
        }

        @Generated
        public String toString() {
            return "LiquidityPoolParameters.LiquidityPoolParametersBuilder(discriminant=" + this.discriminant + ", constantProduct=" + this.constantProduct + ")";
        }
    }
}

