/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Price;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class OfferEntry
implements XdrElement {
    private AccountID sellerID;
    private Int64 offerID;
    private Asset selling;
    private Asset buying;
    private Int64 amount;
    private Price price;
    private Uint32 flags;
    private OfferEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.sellerID.encode(stream);
        this.offerID.encode(stream);
        this.selling.encode(stream);
        this.buying.encode(stream);
        this.amount.encode(stream);
        this.price.encode(stream);
        this.flags.encode(stream);
        this.ext.encode(stream);
    }

    public static OfferEntry decode(XdrDataInputStream stream) throws IOException {
        OfferEntry decodedOfferEntry = new OfferEntry();
        decodedOfferEntry.sellerID = AccountID.decode(stream);
        decodedOfferEntry.offerID = Int64.decode(stream);
        decodedOfferEntry.selling = Asset.decode(stream);
        decodedOfferEntry.buying = Asset.decode(stream);
        decodedOfferEntry.amount = Int64.decode(stream);
        decodedOfferEntry.price = Price.decode(stream);
        decodedOfferEntry.flags = Uint32.decode(stream);
        decodedOfferEntry.ext = OfferEntryExt.decode(stream);
        return decodedOfferEntry;
    }

    public static OfferEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return OfferEntry.fromXdrByteArray(bytes);
    }

    public static OfferEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return OfferEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static OfferEntryBuilder builder() {
        return new OfferEntryBuilder();
    }

    @Generated
    public OfferEntryBuilder toBuilder() {
        return new OfferEntryBuilder().sellerID(this.sellerID).offerID(this.offerID).selling(this.selling).buying(this.buying).amount(this.amount).price(this.price).flags(this.flags).ext(this.ext);
    }

    @Generated
    public AccountID getSellerID() {
        return this.sellerID;
    }

    @Generated
    public Int64 getOfferID() {
        return this.offerID;
    }

    @Generated
    public Asset getSelling() {
        return this.selling;
    }

    @Generated
    public Asset getBuying() {
        return this.buying;
    }

    @Generated
    public Int64 getAmount() {
        return this.amount;
    }

    @Generated
    public Price getPrice() {
        return this.price;
    }

    @Generated
    public Uint32 getFlags() {
        return this.flags;
    }

    @Generated
    public OfferEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setSellerID(AccountID sellerID) {
        this.sellerID = sellerID;
    }

    @Generated
    public void setOfferID(Int64 offerID) {
        this.offerID = offerID;
    }

    @Generated
    public void setSelling(Asset selling) {
        this.selling = selling;
    }

    @Generated
    public void setBuying(Asset buying) {
        this.buying = buying;
    }

    @Generated
    public void setAmount(Int64 amount) {
        this.amount = amount;
    }

    @Generated
    public void setPrice(Price price) {
        this.price = price;
    }

    @Generated
    public void setFlags(Uint32 flags) {
        this.flags = flags;
    }

    @Generated
    public void setExt(OfferEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfferEntry)) {
            return false;
        }
        OfferEntry other = (OfferEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$sellerID = this.getSellerID();
        AccountID other$sellerID = other.getSellerID();
        if (this$sellerID == null ? other$sellerID != null : !((Object)this$sellerID).equals(other$sellerID)) {
            return false;
        }
        Int64 this$offerID = this.getOfferID();
        Int64 other$offerID = other.getOfferID();
        if (this$offerID == null ? other$offerID != null : !((Object)this$offerID).equals(other$offerID)) {
            return false;
        }
        Asset this$selling = this.getSelling();
        Asset other$selling = other.getSelling();
        if (this$selling == null ? other$selling != null : !((Object)this$selling).equals(other$selling)) {
            return false;
        }
        Asset this$buying = this.getBuying();
        Asset other$buying = other.getBuying();
        if (this$buying == null ? other$buying != null : !((Object)this$buying).equals(other$buying)) {
            return false;
        }
        Int64 this$amount = this.getAmount();
        Int64 other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Price this$price = this.getPrice();
        Price other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Uint32 this$flags = this.getFlags();
        Uint32 other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        OfferEntryExt this$ext = this.getExt();
        OfferEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OfferEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $sellerID = this.getSellerID();
        result = result * 59 + ($sellerID == null ? 43 : ((Object)$sellerID).hashCode());
        Int64 $offerID = this.getOfferID();
        result = result * 59 + ($offerID == null ? 43 : ((Object)$offerID).hashCode());
        Asset $selling = this.getSelling();
        result = result * 59 + ($selling == null ? 43 : ((Object)$selling).hashCode());
        Asset $buying = this.getBuying();
        result = result * 59 + ($buying == null ? 43 : ((Object)$buying).hashCode());
        Int64 $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Price $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Uint32 $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        OfferEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OfferEntry(sellerID=" + this.getSellerID() + ", offerID=" + this.getOfferID() + ", selling=" + this.getSelling() + ", buying=" + this.getBuying() + ", amount=" + this.getAmount() + ", price=" + this.getPrice() + ", flags=" + this.getFlags() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public OfferEntry() {
    }

    @Generated
    public OfferEntry(AccountID sellerID, Int64 offerID, Asset selling, Asset buying, Int64 amount, Price price, Uint32 flags, OfferEntryExt ext) {
        this.sellerID = sellerID;
        this.offerID = offerID;
        this.selling = selling;
        this.buying = buying;
        this.amount = amount;
        this.price = price;
        this.flags = flags;
        this.ext = ext;
    }

    public static class OfferEntryExt
    implements XdrElement {
        private Integer discriminant;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                default: 
            }
        }

        public static OfferEntryExt decode(XdrDataInputStream stream) throws IOException {
            OfferEntryExt decodedOfferEntryExt = new OfferEntryExt();
            Integer discriminant = stream.readInt();
            decodedOfferEntryExt.setDiscriminant(discriminant);
            switch (decodedOfferEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedOfferEntryExt;
        }

        public static OfferEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return OfferEntryExt.fromXdrByteArray(bytes);
        }

        public static OfferEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return OfferEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static OfferEntryExtBuilder builder() {
            return new OfferEntryExtBuilder();
        }

        @Generated
        public OfferEntryExtBuilder toBuilder() {
            return new OfferEntryExtBuilder().discriminant(this.discriminant);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OfferEntryExt)) {
                return false;
            }
            OfferEntryExt other = (OfferEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            return !(this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OfferEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OfferEntry.OfferEntryExt(discriminant=" + this.getDiscriminant() + ")";
        }

        @Generated
        public OfferEntryExt() {
        }

        @Generated
        public OfferEntryExt(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public static class OfferEntryExtBuilder {
            @Generated
            private Integer discriminant;

            @Generated
            OfferEntryExtBuilder() {
            }

            @Generated
            public OfferEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public OfferEntryExt build() {
                return new OfferEntryExt(this.discriminant);
            }

            @Generated
            public String toString() {
                return "OfferEntry.OfferEntryExt.OfferEntryExtBuilder(discriminant=" + this.discriminant + ")";
            }
        }
    }

    @Generated
    public static class OfferEntryBuilder {
        @Generated
        private AccountID sellerID;
        @Generated
        private Int64 offerID;
        @Generated
        private Asset selling;
        @Generated
        private Asset buying;
        @Generated
        private Int64 amount;
        @Generated
        private Price price;
        @Generated
        private Uint32 flags;
        @Generated
        private OfferEntryExt ext;

        @Generated
        OfferEntryBuilder() {
        }

        @Generated
        public OfferEntryBuilder sellerID(AccountID sellerID) {
            this.sellerID = sellerID;
            return this;
        }

        @Generated
        public OfferEntryBuilder offerID(Int64 offerID) {
            this.offerID = offerID;
            return this;
        }

        @Generated
        public OfferEntryBuilder selling(Asset selling) {
            this.selling = selling;
            return this;
        }

        @Generated
        public OfferEntryBuilder buying(Asset buying) {
            this.buying = buying;
            return this;
        }

        @Generated
        public OfferEntryBuilder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public OfferEntryBuilder price(Price price) {
            this.price = price;
            return this;
        }

        @Generated
        public OfferEntryBuilder flags(Uint32 flags) {
            this.flags = flags;
            return this;
        }

        @Generated
        public OfferEntryBuilder ext(OfferEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public OfferEntry build() {
            return new OfferEntry(this.sellerID, this.offerID, this.selling, this.buying, this.amount, this.price, this.flags, this.ext);
        }

        @Generated
        public String toString() {
            return "OfferEntry.OfferEntryBuilder(sellerID=" + this.sellerID + ", offerID=" + this.offerID + ", selling=" + this.selling + ", buying=" + this.buying + ", amount=" + this.amount + ", price=" + this.price + ", flags=" + this.flags + ", ext=" + this.ext + ")";
        }
    }
}

