/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCNonceKey
implements XdrElement {
    private Int64 nonce;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.nonce.encode(stream);
    }

    public static SCNonceKey decode(XdrDataInputStream stream) throws IOException {
        SCNonceKey decodedSCNonceKey = new SCNonceKey();
        decodedSCNonceKey.nonce = Int64.decode(stream);
        return decodedSCNonceKey;
    }

    public static SCNonceKey fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCNonceKey.fromXdrByteArray(bytes);
    }

    public static SCNonceKey fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCNonceKey.decode(xdrDataInputStream);
    }

    @Generated
    public static SCNonceKeyBuilder builder() {
        return new SCNonceKeyBuilder();
    }

    @Generated
    public SCNonceKeyBuilder toBuilder() {
        return new SCNonceKeyBuilder().nonce(this.nonce);
    }

    @Generated
    public Int64 getNonce() {
        return this.nonce;
    }

    @Generated
    public void setNonce(Int64 nonce) {
        this.nonce = nonce;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCNonceKey)) {
            return false;
        }
        SCNonceKey other = (SCNonceKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Int64 this$nonce = this.getNonce();
        Int64 other$nonce = other.getNonce();
        return !(this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCNonceKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Int64 $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCNonceKey(nonce=" + this.getNonce() + ")";
    }

    @Generated
    public SCNonceKey() {
    }

    @Generated
    public SCNonceKey(Int64 nonce) {
        this.nonce = nonce;
    }

    @Generated
    public static class SCNonceKeyBuilder {
        @Generated
        private Int64 nonce;

        @Generated
        SCNonceKeyBuilder() {
        }

        @Generated
        public SCNonceKeyBuilder nonce(Int64 nonce) {
            this.nonce = nonce;
            return this;
        }

        @Generated
        public SCNonceKey build() {
            return new SCNonceKey(this.nonce);
        }

        @Generated
        public String toString() {
            return "SCNonceKey.SCNonceKeyBuilder(nonce=" + this.nonce + ")";
        }
    }
}

