/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.BinaryFuseFilterType;
import org.stellar.sdk.xdr.ShortHashSeed;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SerializedBinaryFuseFilter
implements XdrElement {
    private BinaryFuseFilterType type;
    private ShortHashSeed inputHashSeed;
    private ShortHashSeed filterSeed;
    private Uint32 segmentLength;
    private Uint32 segementLengthMask;
    private Uint32 segmentCount;
    private Uint32 segmentCountLength;
    private Uint32 fingerprintLength;
    private byte[] fingerprints;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.type.encode(stream);
        this.inputHashSeed.encode(stream);
        this.filterSeed.encode(stream);
        this.segmentLength.encode(stream);
        this.segementLengthMask.encode(stream);
        this.segmentCount.encode(stream);
        this.segmentCountLength.encode(stream);
        this.fingerprintLength.encode(stream);
        int fingerprintsSize = this.fingerprints.length;
        stream.writeInt(fingerprintsSize);
        stream.write(this.getFingerprints(), 0, fingerprintsSize);
    }

    public static SerializedBinaryFuseFilter decode(XdrDataInputStream stream) throws IOException {
        SerializedBinaryFuseFilter decodedSerializedBinaryFuseFilter = new SerializedBinaryFuseFilter();
        decodedSerializedBinaryFuseFilter.type = BinaryFuseFilterType.decode(stream);
        decodedSerializedBinaryFuseFilter.inputHashSeed = ShortHashSeed.decode(stream);
        decodedSerializedBinaryFuseFilter.filterSeed = ShortHashSeed.decode(stream);
        decodedSerializedBinaryFuseFilter.segmentLength = Uint32.decode(stream);
        decodedSerializedBinaryFuseFilter.segementLengthMask = Uint32.decode(stream);
        decodedSerializedBinaryFuseFilter.segmentCount = Uint32.decode(stream);
        decodedSerializedBinaryFuseFilter.segmentCountLength = Uint32.decode(stream);
        decodedSerializedBinaryFuseFilter.fingerprintLength = Uint32.decode(stream);
        int fingerprintsSize = stream.readInt();
        decodedSerializedBinaryFuseFilter.fingerprints = new byte[fingerprintsSize];
        stream.read(decodedSerializedBinaryFuseFilter.fingerprints, 0, fingerprintsSize);
        return decodedSerializedBinaryFuseFilter;
    }

    public static SerializedBinaryFuseFilter fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SerializedBinaryFuseFilter.fromXdrByteArray(bytes);
    }

    public static SerializedBinaryFuseFilter fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SerializedBinaryFuseFilter.decode(xdrDataInputStream);
    }

    @Generated
    public static SerializedBinaryFuseFilterBuilder builder() {
        return new SerializedBinaryFuseFilterBuilder();
    }

    @Generated
    public SerializedBinaryFuseFilterBuilder toBuilder() {
        return new SerializedBinaryFuseFilterBuilder().type(this.type).inputHashSeed(this.inputHashSeed).filterSeed(this.filterSeed).segmentLength(this.segmentLength).segementLengthMask(this.segementLengthMask).segmentCount(this.segmentCount).segmentCountLength(this.segmentCountLength).fingerprintLength(this.fingerprintLength).fingerprints(this.fingerprints);
    }

    @Generated
    public BinaryFuseFilterType getType() {
        return this.type;
    }

    @Generated
    public ShortHashSeed getInputHashSeed() {
        return this.inputHashSeed;
    }

    @Generated
    public ShortHashSeed getFilterSeed() {
        return this.filterSeed;
    }

    @Generated
    public Uint32 getSegmentLength() {
        return this.segmentLength;
    }

    @Generated
    public Uint32 getSegementLengthMask() {
        return this.segementLengthMask;
    }

    @Generated
    public Uint32 getSegmentCount() {
        return this.segmentCount;
    }

    @Generated
    public Uint32 getSegmentCountLength() {
        return this.segmentCountLength;
    }

    @Generated
    public Uint32 getFingerprintLength() {
        return this.fingerprintLength;
    }

    @Generated
    public byte[] getFingerprints() {
        return this.fingerprints;
    }

    @Generated
    public void setType(BinaryFuseFilterType type) {
        this.type = type;
    }

    @Generated
    public void setInputHashSeed(ShortHashSeed inputHashSeed) {
        this.inputHashSeed = inputHashSeed;
    }

    @Generated
    public void setFilterSeed(ShortHashSeed filterSeed) {
        this.filterSeed = filterSeed;
    }

    @Generated
    public void setSegmentLength(Uint32 segmentLength) {
        this.segmentLength = segmentLength;
    }

    @Generated
    public void setSegementLengthMask(Uint32 segementLengthMask) {
        this.segementLengthMask = segementLengthMask;
    }

    @Generated
    public void setSegmentCount(Uint32 segmentCount) {
        this.segmentCount = segmentCount;
    }

    @Generated
    public void setSegmentCountLength(Uint32 segmentCountLength) {
        this.segmentCountLength = segmentCountLength;
    }

    @Generated
    public void setFingerprintLength(Uint32 fingerprintLength) {
        this.fingerprintLength = fingerprintLength;
    }

    @Generated
    public void setFingerprints(byte[] fingerprints) {
        this.fingerprints = fingerprints;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializedBinaryFuseFilter)) {
            return false;
        }
        SerializedBinaryFuseFilter other = (SerializedBinaryFuseFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BinaryFuseFilterType this$type = this.getType();
        BinaryFuseFilterType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ShortHashSeed this$inputHashSeed = this.getInputHashSeed();
        ShortHashSeed other$inputHashSeed = other.getInputHashSeed();
        if (this$inputHashSeed == null ? other$inputHashSeed != null : !((Object)this$inputHashSeed).equals(other$inputHashSeed)) {
            return false;
        }
        ShortHashSeed this$filterSeed = this.getFilterSeed();
        ShortHashSeed other$filterSeed = other.getFilterSeed();
        if (this$filterSeed == null ? other$filterSeed != null : !((Object)this$filterSeed).equals(other$filterSeed)) {
            return false;
        }
        Uint32 this$segmentLength = this.getSegmentLength();
        Uint32 other$segmentLength = other.getSegmentLength();
        if (this$segmentLength == null ? other$segmentLength != null : !((Object)this$segmentLength).equals(other$segmentLength)) {
            return false;
        }
        Uint32 this$segementLengthMask = this.getSegementLengthMask();
        Uint32 other$segementLengthMask = other.getSegementLengthMask();
        if (this$segementLengthMask == null ? other$segementLengthMask != null : !((Object)this$segementLengthMask).equals(other$segementLengthMask)) {
            return false;
        }
        Uint32 this$segmentCount = this.getSegmentCount();
        Uint32 other$segmentCount = other.getSegmentCount();
        if (this$segmentCount == null ? other$segmentCount != null : !((Object)this$segmentCount).equals(other$segmentCount)) {
            return false;
        }
        Uint32 this$segmentCountLength = this.getSegmentCountLength();
        Uint32 other$segmentCountLength = other.getSegmentCountLength();
        if (this$segmentCountLength == null ? other$segmentCountLength != null : !((Object)this$segmentCountLength).equals(other$segmentCountLength)) {
            return false;
        }
        Uint32 this$fingerprintLength = this.getFingerprintLength();
        Uint32 other$fingerprintLength = other.getFingerprintLength();
        if (this$fingerprintLength == null ? other$fingerprintLength != null : !((Object)this$fingerprintLength).equals(other$fingerprintLength)) {
            return false;
        }
        return Arrays.equals(this.getFingerprints(), other.getFingerprints());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SerializedBinaryFuseFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BinaryFuseFilterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ShortHashSeed $inputHashSeed = this.getInputHashSeed();
        result = result * 59 + ($inputHashSeed == null ? 43 : ((Object)$inputHashSeed).hashCode());
        ShortHashSeed $filterSeed = this.getFilterSeed();
        result = result * 59 + ($filterSeed == null ? 43 : ((Object)$filterSeed).hashCode());
        Uint32 $segmentLength = this.getSegmentLength();
        result = result * 59 + ($segmentLength == null ? 43 : ((Object)$segmentLength).hashCode());
        Uint32 $segementLengthMask = this.getSegementLengthMask();
        result = result * 59 + ($segementLengthMask == null ? 43 : ((Object)$segementLengthMask).hashCode());
        Uint32 $segmentCount = this.getSegmentCount();
        result = result * 59 + ($segmentCount == null ? 43 : ((Object)$segmentCount).hashCode());
        Uint32 $segmentCountLength = this.getSegmentCountLength();
        result = result * 59 + ($segmentCountLength == null ? 43 : ((Object)$segmentCountLength).hashCode());
        Uint32 $fingerprintLength = this.getFingerprintLength();
        result = result * 59 + ($fingerprintLength == null ? 43 : ((Object)$fingerprintLength).hashCode());
        result = result * 59 + Arrays.hashCode(this.getFingerprints());
        return result;
    }

    @Generated
    public String toString() {
        return "SerializedBinaryFuseFilter(type=" + this.getType() + ", inputHashSeed=" + this.getInputHashSeed() + ", filterSeed=" + this.getFilterSeed() + ", segmentLength=" + this.getSegmentLength() + ", segementLengthMask=" + this.getSegementLengthMask() + ", segmentCount=" + this.getSegmentCount() + ", segmentCountLength=" + this.getSegmentCountLength() + ", fingerprintLength=" + this.getFingerprintLength() + ", fingerprints=" + Arrays.toString(this.getFingerprints()) + ")";
    }

    @Generated
    public SerializedBinaryFuseFilter() {
    }

    @Generated
    public SerializedBinaryFuseFilter(BinaryFuseFilterType type, ShortHashSeed inputHashSeed, ShortHashSeed filterSeed, Uint32 segmentLength, Uint32 segementLengthMask, Uint32 segmentCount, Uint32 segmentCountLength, Uint32 fingerprintLength, byte[] fingerprints) {
        this.type = type;
        this.inputHashSeed = inputHashSeed;
        this.filterSeed = filterSeed;
        this.segmentLength = segmentLength;
        this.segementLengthMask = segementLengthMask;
        this.segmentCount = segmentCount;
        this.segmentCountLength = segmentCountLength;
        this.fingerprintLength = fingerprintLength;
        this.fingerprints = fingerprints;
    }

    @Generated
    public static class SerializedBinaryFuseFilterBuilder {
        @Generated
        private BinaryFuseFilterType type;
        @Generated
        private ShortHashSeed inputHashSeed;
        @Generated
        private ShortHashSeed filterSeed;
        @Generated
        private Uint32 segmentLength;
        @Generated
        private Uint32 segementLengthMask;
        @Generated
        private Uint32 segmentCount;
        @Generated
        private Uint32 segmentCountLength;
        @Generated
        private Uint32 fingerprintLength;
        @Generated
        private byte[] fingerprints;

        @Generated
        SerializedBinaryFuseFilterBuilder() {
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder type(BinaryFuseFilterType type) {
            this.type = type;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder inputHashSeed(ShortHashSeed inputHashSeed) {
            this.inputHashSeed = inputHashSeed;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder filterSeed(ShortHashSeed filterSeed) {
            this.filterSeed = filterSeed;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder segmentLength(Uint32 segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder segementLengthMask(Uint32 segementLengthMask) {
            this.segementLengthMask = segementLengthMask;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder segmentCount(Uint32 segmentCount) {
            this.segmentCount = segmentCount;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder segmentCountLength(Uint32 segmentCountLength) {
            this.segmentCountLength = segmentCountLength;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder fingerprintLength(Uint32 fingerprintLength) {
            this.fingerprintLength = fingerprintLength;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilterBuilder fingerprints(byte[] fingerprints) {
            this.fingerprints = fingerprints;
            return this;
        }

        @Generated
        public SerializedBinaryFuseFilter build() {
            return new SerializedBinaryFuseFilter(this.type, this.inputHashSeed, this.filterSeed, this.segmentLength, this.segementLengthMask, this.segmentCount, this.segmentCountLength, this.fingerprintLength, this.fingerprints);
        }

        @Generated
        public String toString() {
            return "SerializedBinaryFuseFilter.SerializedBinaryFuseFilterBuilder(type=" + this.type + ", inputHashSeed=" + this.inputHashSeed + ", filterSeed=" + this.filterSeed + ", segmentLength=" + this.segmentLength + ", segementLengthMask=" + this.segementLengthMask + ", segmentCount=" + this.segmentCount + ", segmentCountLength=" + this.segmentCountLength + ", fingerprintLength=" + this.fingerprintLength + ", fingerprints=" + Arrays.toString(this.fingerprints) + ")";
        }
    }
}

