// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ColdArchiveBoundaryLeaf's original definition in the XDR file is:
 *
 * <pre>
 * struct ColdArchiveBoundaryLeaf
 * {
 *     uint32 index;
 *     bool isLowerBound;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ColdArchiveBoundaryLeaf implements XdrElement {
  private Uint32 index;
  private Boolean isLowerBound;

  public void encode(XdrDataOutputStream stream) throws IOException {
    index.encode(stream);
    stream.writeInt(isLowerBound ? 1 : 0);
  }

  public static ColdArchiveBoundaryLeaf decode(XdrDataInputStream stream) throws IOException {
    ColdArchiveBoundaryLeaf decodedColdArchiveBoundaryLeaf = new ColdArchiveBoundaryLeaf();
    decodedColdArchiveBoundaryLeaf.index = Uint32.decode(stream);
    decodedColdArchiveBoundaryLeaf.isLowerBound = stream.readInt() == 1 ? true : false;
    return decodedColdArchiveBoundaryLeaf;
  }

  public static ColdArchiveBoundaryLeaf fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ColdArchiveBoundaryLeaf fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
