// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * ColdArchiveBucketEntryType's original definition in the XDR file is:
 *
 * <pre>
 * enum ColdArchiveBucketEntryType
 * {
 *     COLD_ARCHIVE_METAENTRY     = -1,  // Bucket metadata, should come first.
 *     COLD_ARCHIVE_ARCHIVED_LEAF = 0,   // Full LedgerEntry that was archived during the epoch
 *     COLD_ARCHIVE_DELETED_LEAF  = 1,   // LedgerKey that was deleted during the epoch
 *     COLD_ARCHIVE_BOUNDARY_LEAF = 2,   // Dummy leaf representing low/high bound
 *     COLD_ARCHIVE_HASH          = 3    // Intermediary Merkle hash entry
 * };
 * </pre>
 */
public enum ColdArchiveBucketEntryType implements XdrElement {
  COLD_ARCHIVE_METAENTRY(-1),
  COLD_ARCHIVE_ARCHIVED_LEAF(0),
  COLD_ARCHIVE_DELETED_LEAF(1),
  COLD_ARCHIVE_BOUNDARY_LEAF(2),
  COLD_ARCHIVE_HASH(3);

  private final int value;

  ColdArchiveBucketEntryType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static ColdArchiveBucketEntryType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case -1:
        return COLD_ARCHIVE_METAENTRY;
      case 0:
        return COLD_ARCHIVE_ARCHIVED_LEAF;
      case 1:
        return COLD_ARCHIVE_DELETED_LEAF;
      case 2:
        return COLD_ARCHIVE_BOUNDARY_LEAF;
      case 3:
        return COLD_ARCHIVE_HASH;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static ColdArchiveBucketEntryType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ColdArchiveBucketEntryType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
