// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ConfigSettingEntry's original definition in the XDR file is:
 *
 * <pre>
 * union ConfigSettingEntry switch (ConfigSettingID configSettingID)
 * {
 * case CONFIG_SETTING_CONTRACT_MAX_SIZE_BYTES:
 *     uint32 contractMaxSizeBytes;
 * case CONFIG_SETTING_CONTRACT_COMPUTE_V0:
 *     ConfigSettingContractComputeV0 contractCompute;
 * case CONFIG_SETTING_CONTRACT_LEDGER_COST_V0:
 *     ConfigSettingContractLedgerCostV0 contractLedgerCost;
 * case CONFIG_SETTING_CONTRACT_HISTORICAL_DATA_V0:
 *     ConfigSettingContractHistoricalDataV0 contractHistoricalData;
 * case CONFIG_SETTING_CONTRACT_EVENTS_V0:
 *     ConfigSettingContractEventsV0 contractEvents;
 * case CONFIG_SETTING_CONTRACT_BANDWIDTH_V0:
 *     ConfigSettingContractBandwidthV0 contractBandwidth;
 * case CONFIG_SETTING_CONTRACT_COST_PARAMS_CPU_INSTRUCTIONS:
 *     ContractCostParams contractCostParamsCpuInsns;
 * case CONFIG_SETTING_CONTRACT_COST_PARAMS_MEMORY_BYTES:
 *     ContractCostParams contractCostParamsMemBytes;
 * case CONFIG_SETTING_CONTRACT_DATA_KEY_SIZE_BYTES:
 *     uint32 contractDataKeySizeBytes;
 * case CONFIG_SETTING_CONTRACT_DATA_ENTRY_SIZE_BYTES:
 *     uint32 contractDataEntrySizeBytes;
 * case CONFIG_SETTING_STATE_ARCHIVAL:
 *     StateArchivalSettings stateArchivalSettings;
 * case CONFIG_SETTING_CONTRACT_EXECUTION_LANES:
 *     ConfigSettingContractExecutionLanesV0 contractExecutionLanes;
 * case CONFIG_SETTING_BUCKETLIST_SIZE_WINDOW:
 *     uint64 bucketListSizeWindow&lt;&gt;;
 * case CONFIG_SETTING_EVICTION_ITERATOR:
 *     EvictionIterator evictionIterator;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ConfigSettingEntry implements XdrElement {
  private ConfigSettingID discriminant;
  private Uint32 contractMaxSizeBytes;
  private ConfigSettingContractComputeV0 contractCompute;
  private ConfigSettingContractLedgerCostV0 contractLedgerCost;
  private ConfigSettingContractHistoricalDataV0 contractHistoricalData;
  private ConfigSettingContractEventsV0 contractEvents;
  private ConfigSettingContractBandwidthV0 contractBandwidth;
  private ContractCostParams contractCostParamsCpuInsns;
  private ContractCostParams contractCostParamsMemBytes;
  private Uint32 contractDataKeySizeBytes;
  private Uint32 contractDataEntrySizeBytes;
  private StateArchivalSettings stateArchivalSettings;
  private ConfigSettingContractExecutionLanesV0 contractExecutionLanes;
  private Uint64[] bucketListSizeWindow;
  private EvictionIterator evictionIterator;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case CONFIG_SETTING_CONTRACT_MAX_SIZE_BYTES:
        contractMaxSizeBytes.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_COMPUTE_V0:
        contractCompute.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_LEDGER_COST_V0:
        contractLedgerCost.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_HISTORICAL_DATA_V0:
        contractHistoricalData.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_EVENTS_V0:
        contractEvents.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_BANDWIDTH_V0:
        contractBandwidth.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_COST_PARAMS_CPU_INSTRUCTIONS:
        contractCostParamsCpuInsns.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_COST_PARAMS_MEMORY_BYTES:
        contractCostParamsMemBytes.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_DATA_KEY_SIZE_BYTES:
        contractDataKeySizeBytes.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_DATA_ENTRY_SIZE_BYTES:
        contractDataEntrySizeBytes.encode(stream);
        break;
      case CONFIG_SETTING_STATE_ARCHIVAL:
        stateArchivalSettings.encode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_EXECUTION_LANES:
        contractExecutionLanes.encode(stream);
        break;
      case CONFIG_SETTING_BUCKETLIST_SIZE_WINDOW:
        int bucketListSizeWindowSize = getBucketListSizeWindow().length;
        stream.writeInt(bucketListSizeWindowSize);
        for (int i = 0; i < bucketListSizeWindowSize; i++) {
          bucketListSizeWindow[i].encode(stream);
        }
        break;
      case CONFIG_SETTING_EVICTION_ITERATOR:
        evictionIterator.encode(stream);
        break;
    }
  }

  public static ConfigSettingEntry decode(XdrDataInputStream stream) throws IOException {
    ConfigSettingEntry decodedConfigSettingEntry = new ConfigSettingEntry();
    ConfigSettingID discriminant = ConfigSettingID.decode(stream);
    decodedConfigSettingEntry.setDiscriminant(discriminant);
    switch (decodedConfigSettingEntry.getDiscriminant()) {
      case CONFIG_SETTING_CONTRACT_MAX_SIZE_BYTES:
        decodedConfigSettingEntry.contractMaxSizeBytes = Uint32.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_COMPUTE_V0:
        decodedConfigSettingEntry.contractCompute = ConfigSettingContractComputeV0.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_LEDGER_COST_V0:
        decodedConfigSettingEntry.contractLedgerCost =
            ConfigSettingContractLedgerCostV0.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_HISTORICAL_DATA_V0:
        decodedConfigSettingEntry.contractHistoricalData =
            ConfigSettingContractHistoricalDataV0.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_EVENTS_V0:
        decodedConfigSettingEntry.contractEvents = ConfigSettingContractEventsV0.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_BANDWIDTH_V0:
        decodedConfigSettingEntry.contractBandwidth =
            ConfigSettingContractBandwidthV0.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_COST_PARAMS_CPU_INSTRUCTIONS:
        decodedConfigSettingEntry.contractCostParamsCpuInsns = ContractCostParams.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_COST_PARAMS_MEMORY_BYTES:
        decodedConfigSettingEntry.contractCostParamsMemBytes = ContractCostParams.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_DATA_KEY_SIZE_BYTES:
        decodedConfigSettingEntry.contractDataKeySizeBytes = Uint32.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_DATA_ENTRY_SIZE_BYTES:
        decodedConfigSettingEntry.contractDataEntrySizeBytes = Uint32.decode(stream);
        break;
      case CONFIG_SETTING_STATE_ARCHIVAL:
        decodedConfigSettingEntry.stateArchivalSettings = StateArchivalSettings.decode(stream);
        break;
      case CONFIG_SETTING_CONTRACT_EXECUTION_LANES:
        decodedConfigSettingEntry.contractExecutionLanes =
            ConfigSettingContractExecutionLanesV0.decode(stream);
        break;
      case CONFIG_SETTING_BUCKETLIST_SIZE_WINDOW:
        int bucketListSizeWindowSize = stream.readInt();
        decodedConfigSettingEntry.bucketListSizeWindow = new Uint64[bucketListSizeWindowSize];
        for (int i = 0; i < bucketListSizeWindowSize; i++) {
          decodedConfigSettingEntry.bucketListSizeWindow[i] = Uint64.decode(stream);
        }
        break;
      case CONFIG_SETTING_EVICTION_ITERATOR:
        decodedConfigSettingEntry.evictionIterator = EvictionIterator.decode(stream);
        break;
    }
    return decodedConfigSettingEntry;
  }

  public static ConfigSettingEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ConfigSettingEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
