// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * HmacSha256Mac's original definition in the XDR file is:
 *
 * <pre>
 * struct HmacSha256Mac
 * {
 *     opaque mac[32];
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class HmacSha256Mac implements XdrElement {
  private byte[] mac;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int macSize = mac.length;
    stream.write(getMac(), 0, macSize);
  }

  public static HmacSha256Mac decode(XdrDataInputStream stream) throws IOException {
    HmacSha256Mac decodedHmacSha256Mac = new HmacSha256Mac();
    int macSize = 32;
    decodedHmacSha256Mac.mac = new byte[macSize];
    stream.read(decodedHmacSha256Mac.mac, 0, macSize);
    return decodedHmacSha256Mac;
  }

  public static HmacSha256Mac fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static HmacSha256Mac fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
