// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * OperationResult's original definition in the XDR file is:
 *
 * <pre>
 * union OperationResult switch (OperationResultCode code)
 * {
 * case opINNER:
 *     union switch (OperationType type)
 *     {
 *     case CREATE_ACCOUNT:
 *         CreateAccountResult createAccountResult;
 *     case PAYMENT:
 *         PaymentResult paymentResult;
 *     case PATH_PAYMENT_STRICT_RECEIVE:
 *         PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
 *     case MANAGE_SELL_OFFER:
 *         ManageSellOfferResult manageSellOfferResult;
 *     case CREATE_PASSIVE_SELL_OFFER:
 *         ManageSellOfferResult createPassiveSellOfferResult;
 *     case SET_OPTIONS:
 *         SetOptionsResult setOptionsResult;
 *     case CHANGE_TRUST:
 *         ChangeTrustResult changeTrustResult;
 *     case ALLOW_TRUST:
 *         AllowTrustResult allowTrustResult;
 *     case ACCOUNT_MERGE:
 *         AccountMergeResult accountMergeResult;
 *     case INFLATION:
 *         InflationResult inflationResult;
 *     case MANAGE_DATA:
 *         ManageDataResult manageDataResult;
 *     case BUMP_SEQUENCE:
 *         BumpSequenceResult bumpSeqResult;
 *     case MANAGE_BUY_OFFER:
 *         ManageBuyOfferResult manageBuyOfferResult;
 *     case PATH_PAYMENT_STRICT_SEND:
 *         PathPaymentStrictSendResult pathPaymentStrictSendResult;
 *     case CREATE_CLAIMABLE_BALANCE:
 *         CreateClaimableBalanceResult createClaimableBalanceResult;
 *     case CLAIM_CLAIMABLE_BALANCE:
 *         ClaimClaimableBalanceResult claimClaimableBalanceResult;
 *     case BEGIN_SPONSORING_FUTURE_RESERVES:
 *         BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
 *     case END_SPONSORING_FUTURE_RESERVES:
 *         EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
 *     case REVOKE_SPONSORSHIP:
 *         RevokeSponsorshipResult revokeSponsorshipResult;
 *     case CLAWBACK:
 *         ClawbackResult clawbackResult;
 *     case CLAWBACK_CLAIMABLE_BALANCE:
 *         ClawbackClaimableBalanceResult clawbackClaimableBalanceResult;
 *     case SET_TRUST_LINE_FLAGS:
 *         SetTrustLineFlagsResult setTrustLineFlagsResult;
 *     case LIQUIDITY_POOL_DEPOSIT:
 *         LiquidityPoolDepositResult liquidityPoolDepositResult;
 *     case LIQUIDITY_POOL_WITHDRAW:
 *         LiquidityPoolWithdrawResult liquidityPoolWithdrawResult;
 *     case INVOKE_HOST_FUNCTION:
 *         InvokeHostFunctionResult invokeHostFunctionResult;
 *     case EXTEND_FOOTPRINT_TTL:
 *         ExtendFootprintTTLResult extendFootprintTTLResult;
 *     case RESTORE_FOOTPRINT:
 *         RestoreFootprintResult restoreFootprintResult;
 *     }
 *     tr;
 * case opBAD_AUTH:
 * case opNO_ACCOUNT:
 * case opNOT_SUPPORTED:
 * case opTOO_MANY_SUBENTRIES:
 * case opEXCEEDED_WORK_LIMIT:
 * case opTOO_MANY_SPONSORING:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class OperationResult implements XdrElement {
  private OperationResultCode discriminant;
  private OperationResultTr tr;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case opINNER:
        tr.encode(stream);
        break;
      case opBAD_AUTH:
      case opNO_ACCOUNT:
      case opNOT_SUPPORTED:
      case opTOO_MANY_SUBENTRIES:
      case opEXCEEDED_WORK_LIMIT:
      case opTOO_MANY_SPONSORING:
        break;
    }
  }

  public static OperationResult decode(XdrDataInputStream stream) throws IOException {
    OperationResult decodedOperationResult = new OperationResult();
    OperationResultCode discriminant = OperationResultCode.decode(stream);
    decodedOperationResult.setDiscriminant(discriminant);
    switch (decodedOperationResult.getDiscriminant()) {
      case opINNER:
        decodedOperationResult.tr = OperationResultTr.decode(stream);
        break;
      case opBAD_AUTH:
      case opNO_ACCOUNT:
      case opNOT_SUPPORTED:
      case opTOO_MANY_SUBENTRIES:
      case opEXCEEDED_WORK_LIMIT:
      case opTOO_MANY_SPONSORING:
        break;
    }
    return decodedOperationResult;
  }

  public static OperationResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static OperationResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * OperationResultTr's original definition in the XDR file is:
   *
   * <pre>
   * union switch (OperationType type)
   *     {
   *     case CREATE_ACCOUNT:
   *         CreateAccountResult createAccountResult;
   *     case PAYMENT:
   *         PaymentResult paymentResult;
   *     case PATH_PAYMENT_STRICT_RECEIVE:
   *         PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
   *     case MANAGE_SELL_OFFER:
   *         ManageSellOfferResult manageSellOfferResult;
   *     case CREATE_PASSIVE_SELL_OFFER:
   *         ManageSellOfferResult createPassiveSellOfferResult;
   *     case SET_OPTIONS:
   *         SetOptionsResult setOptionsResult;
   *     case CHANGE_TRUST:
   *         ChangeTrustResult changeTrustResult;
   *     case ALLOW_TRUST:
   *         AllowTrustResult allowTrustResult;
   *     case ACCOUNT_MERGE:
   *         AccountMergeResult accountMergeResult;
   *     case INFLATION:
   *         InflationResult inflationResult;
   *     case MANAGE_DATA:
   *         ManageDataResult manageDataResult;
   *     case BUMP_SEQUENCE:
   *         BumpSequenceResult bumpSeqResult;
   *     case MANAGE_BUY_OFFER:
   *         ManageBuyOfferResult manageBuyOfferResult;
   *     case PATH_PAYMENT_STRICT_SEND:
   *         PathPaymentStrictSendResult pathPaymentStrictSendResult;
   *     case CREATE_CLAIMABLE_BALANCE:
   *         CreateClaimableBalanceResult createClaimableBalanceResult;
   *     case CLAIM_CLAIMABLE_BALANCE:
   *         ClaimClaimableBalanceResult claimClaimableBalanceResult;
   *     case BEGIN_SPONSORING_FUTURE_RESERVES:
   *         BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
   *     case END_SPONSORING_FUTURE_RESERVES:
   *         EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
   *     case REVOKE_SPONSORSHIP:
   *         RevokeSponsorshipResult revokeSponsorshipResult;
   *     case CLAWBACK:
   *         ClawbackResult clawbackResult;
   *     case CLAWBACK_CLAIMABLE_BALANCE:
   *         ClawbackClaimableBalanceResult clawbackClaimableBalanceResult;
   *     case SET_TRUST_LINE_FLAGS:
   *         SetTrustLineFlagsResult setTrustLineFlagsResult;
   *     case LIQUIDITY_POOL_DEPOSIT:
   *         LiquidityPoolDepositResult liquidityPoolDepositResult;
   *     case LIQUIDITY_POOL_WITHDRAW:
   *         LiquidityPoolWithdrawResult liquidityPoolWithdrawResult;
   *     case INVOKE_HOST_FUNCTION:
   *         InvokeHostFunctionResult invokeHostFunctionResult;
   *     case EXTEND_FOOTPRINT_TTL:
   *         ExtendFootprintTTLResult extendFootprintTTLResult;
   *     case RESTORE_FOOTPRINT:
   *         RestoreFootprintResult restoreFootprintResult;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class OperationResultTr implements XdrElement {
    private OperationType discriminant;
    private CreateAccountResult createAccountResult;
    private PaymentResult paymentResult;
    private PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
    private ManageSellOfferResult manageSellOfferResult;
    private ManageSellOfferResult createPassiveSellOfferResult;
    private SetOptionsResult setOptionsResult;
    private ChangeTrustResult changeTrustResult;
    private AllowTrustResult allowTrustResult;
    private AccountMergeResult accountMergeResult;
    private InflationResult inflationResult;
    private ManageDataResult manageDataResult;
    private BumpSequenceResult bumpSeqResult;
    private ManageBuyOfferResult manageBuyOfferResult;
    private PathPaymentStrictSendResult pathPaymentStrictSendResult;
    private CreateClaimableBalanceResult createClaimableBalanceResult;
    private ClaimClaimableBalanceResult claimClaimableBalanceResult;
    private BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
    private EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
    private RevokeSponsorshipResult revokeSponsorshipResult;
    private ClawbackResult clawbackResult;
    private ClawbackClaimableBalanceResult clawbackClaimableBalanceResult;
    private SetTrustLineFlagsResult setTrustLineFlagsResult;
    private LiquidityPoolDepositResult liquidityPoolDepositResult;
    private LiquidityPoolWithdrawResult liquidityPoolWithdrawResult;
    private InvokeHostFunctionResult invokeHostFunctionResult;
    private ExtendFootprintTTLResult extendFootprintTTLResult;
    private RestoreFootprintResult restoreFootprintResult;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case CREATE_ACCOUNT:
          createAccountResult.encode(stream);
          break;
        case PAYMENT:
          paymentResult.encode(stream);
          break;
        case PATH_PAYMENT_STRICT_RECEIVE:
          pathPaymentStrictReceiveResult.encode(stream);
          break;
        case MANAGE_SELL_OFFER:
          manageSellOfferResult.encode(stream);
          break;
        case CREATE_PASSIVE_SELL_OFFER:
          createPassiveSellOfferResult.encode(stream);
          break;
        case SET_OPTIONS:
          setOptionsResult.encode(stream);
          break;
        case CHANGE_TRUST:
          changeTrustResult.encode(stream);
          break;
        case ALLOW_TRUST:
          allowTrustResult.encode(stream);
          break;
        case ACCOUNT_MERGE:
          accountMergeResult.encode(stream);
          break;
        case INFLATION:
          inflationResult.encode(stream);
          break;
        case MANAGE_DATA:
          manageDataResult.encode(stream);
          break;
        case BUMP_SEQUENCE:
          bumpSeqResult.encode(stream);
          break;
        case MANAGE_BUY_OFFER:
          manageBuyOfferResult.encode(stream);
          break;
        case PATH_PAYMENT_STRICT_SEND:
          pathPaymentStrictSendResult.encode(stream);
          break;
        case CREATE_CLAIMABLE_BALANCE:
          createClaimableBalanceResult.encode(stream);
          break;
        case CLAIM_CLAIMABLE_BALANCE:
          claimClaimableBalanceResult.encode(stream);
          break;
        case BEGIN_SPONSORING_FUTURE_RESERVES:
          beginSponsoringFutureReservesResult.encode(stream);
          break;
        case END_SPONSORING_FUTURE_RESERVES:
          endSponsoringFutureReservesResult.encode(stream);
          break;
        case REVOKE_SPONSORSHIP:
          revokeSponsorshipResult.encode(stream);
          break;
        case CLAWBACK:
          clawbackResult.encode(stream);
          break;
        case CLAWBACK_CLAIMABLE_BALANCE:
          clawbackClaimableBalanceResult.encode(stream);
          break;
        case SET_TRUST_LINE_FLAGS:
          setTrustLineFlagsResult.encode(stream);
          break;
        case LIQUIDITY_POOL_DEPOSIT:
          liquidityPoolDepositResult.encode(stream);
          break;
        case LIQUIDITY_POOL_WITHDRAW:
          liquidityPoolWithdrawResult.encode(stream);
          break;
        case INVOKE_HOST_FUNCTION:
          invokeHostFunctionResult.encode(stream);
          break;
        case EXTEND_FOOTPRINT_TTL:
          extendFootprintTTLResult.encode(stream);
          break;
        case RESTORE_FOOTPRINT:
          restoreFootprintResult.encode(stream);
          break;
      }
    }

    public static OperationResultTr decode(XdrDataInputStream stream) throws IOException {
      OperationResultTr decodedOperationResultTr = new OperationResultTr();
      OperationType discriminant = OperationType.decode(stream);
      decodedOperationResultTr.setDiscriminant(discriminant);
      switch (decodedOperationResultTr.getDiscriminant()) {
        case CREATE_ACCOUNT:
          decodedOperationResultTr.createAccountResult = CreateAccountResult.decode(stream);
          break;
        case PAYMENT:
          decodedOperationResultTr.paymentResult = PaymentResult.decode(stream);
          break;
        case PATH_PAYMENT_STRICT_RECEIVE:
          decodedOperationResultTr.pathPaymentStrictReceiveResult =
              PathPaymentStrictReceiveResult.decode(stream);
          break;
        case MANAGE_SELL_OFFER:
          decodedOperationResultTr.manageSellOfferResult = ManageSellOfferResult.decode(stream);
          break;
        case CREATE_PASSIVE_SELL_OFFER:
          decodedOperationResultTr.createPassiveSellOfferResult =
              ManageSellOfferResult.decode(stream);
          break;
        case SET_OPTIONS:
          decodedOperationResultTr.setOptionsResult = SetOptionsResult.decode(stream);
          break;
        case CHANGE_TRUST:
          decodedOperationResultTr.changeTrustResult = ChangeTrustResult.decode(stream);
          break;
        case ALLOW_TRUST:
          decodedOperationResultTr.allowTrustResult = AllowTrustResult.decode(stream);
          break;
        case ACCOUNT_MERGE:
          decodedOperationResultTr.accountMergeResult = AccountMergeResult.decode(stream);
          break;
        case INFLATION:
          decodedOperationResultTr.inflationResult = InflationResult.decode(stream);
          break;
        case MANAGE_DATA:
          decodedOperationResultTr.manageDataResult = ManageDataResult.decode(stream);
          break;
        case BUMP_SEQUENCE:
          decodedOperationResultTr.bumpSeqResult = BumpSequenceResult.decode(stream);
          break;
        case MANAGE_BUY_OFFER:
          decodedOperationResultTr.manageBuyOfferResult = ManageBuyOfferResult.decode(stream);
          break;
        case PATH_PAYMENT_STRICT_SEND:
          decodedOperationResultTr.pathPaymentStrictSendResult =
              PathPaymentStrictSendResult.decode(stream);
          break;
        case CREATE_CLAIMABLE_BALANCE:
          decodedOperationResultTr.createClaimableBalanceResult =
              CreateClaimableBalanceResult.decode(stream);
          break;
        case CLAIM_CLAIMABLE_BALANCE:
          decodedOperationResultTr.claimClaimableBalanceResult =
              ClaimClaimableBalanceResult.decode(stream);
          break;
        case BEGIN_SPONSORING_FUTURE_RESERVES:
          decodedOperationResultTr.beginSponsoringFutureReservesResult =
              BeginSponsoringFutureReservesResult.decode(stream);
          break;
        case END_SPONSORING_FUTURE_RESERVES:
          decodedOperationResultTr.endSponsoringFutureReservesResult =
              EndSponsoringFutureReservesResult.decode(stream);
          break;
        case REVOKE_SPONSORSHIP:
          decodedOperationResultTr.revokeSponsorshipResult = RevokeSponsorshipResult.decode(stream);
          break;
        case CLAWBACK:
          decodedOperationResultTr.clawbackResult = ClawbackResult.decode(stream);
          break;
        case CLAWBACK_CLAIMABLE_BALANCE:
          decodedOperationResultTr.clawbackClaimableBalanceResult =
              ClawbackClaimableBalanceResult.decode(stream);
          break;
        case SET_TRUST_LINE_FLAGS:
          decodedOperationResultTr.setTrustLineFlagsResult = SetTrustLineFlagsResult.decode(stream);
          break;
        case LIQUIDITY_POOL_DEPOSIT:
          decodedOperationResultTr.liquidityPoolDepositResult =
              LiquidityPoolDepositResult.decode(stream);
          break;
        case LIQUIDITY_POOL_WITHDRAW:
          decodedOperationResultTr.liquidityPoolWithdrawResult =
              LiquidityPoolWithdrawResult.decode(stream);
          break;
        case INVOKE_HOST_FUNCTION:
          decodedOperationResultTr.invokeHostFunctionResult =
              InvokeHostFunctionResult.decode(stream);
          break;
        case EXTEND_FOOTPRINT_TTL:
          decodedOperationResultTr.extendFootprintTTLResult =
              ExtendFootprintTTLResult.decode(stream);
          break;
        case RESTORE_FOOTPRINT:
          decodedOperationResultTr.restoreFootprintResult = RestoreFootprintResult.decode(stream);
          break;
      }
      return decodedOperationResultTr;
    }

    public static OperationResultTr fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static OperationResultTr fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
