// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * StoredTransactionSet's original definition in the XDR file is:
 *
 * <pre>
 * union StoredTransactionSet switch (int v)
 * {
 * case 0:
 * 	TransactionSet txSet;
 * case 1:
 * 	GeneralizedTransactionSet generalizedTxSet;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class StoredTransactionSet implements XdrElement {
  private Integer discriminant;
  private TransactionSet txSet;
  private GeneralizedTransactionSet generalizedTxSet;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant);
    switch (discriminant) {
      case 0:
        txSet.encode(stream);
        break;
      case 1:
        generalizedTxSet.encode(stream);
        break;
    }
  }

  public static StoredTransactionSet decode(XdrDataInputStream stream) throws IOException {
    StoredTransactionSet decodedStoredTransactionSet = new StoredTransactionSet();
    Integer discriminant = stream.readInt();
    decodedStoredTransactionSet.setDiscriminant(discriminant);
    switch (decodedStoredTransactionSet.getDiscriminant()) {
      case 0:
        decodedStoredTransactionSet.txSet = TransactionSet.decode(stream);
        break;
      case 1:
        decodedStoredTransactionSet.generalizedTxSet = GeneralizedTransactionSet.decode(stream);
        break;
    }
    return decodedStoredTransactionSet;
  }

  public static StoredTransactionSet fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static StoredTransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
