// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionHistoryEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionHistoryEntry
 * {
 *     uint32 ledgerSeq;
 *     TransactionSet txSet;
 *
 *     // when v != 0, txSet must be empty
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     case 1:
 *         GeneralizedTransactionSet generalizedTxSet;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionHistoryEntry implements XdrElement {
  private Uint32 ledgerSeq;
  private TransactionSet txSet;
  private TransactionHistoryEntryExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ledgerSeq.encode(stream);
    txSet.encode(stream);
    ext.encode(stream);
  }

  public static TransactionHistoryEntry decode(XdrDataInputStream stream) throws IOException {
    TransactionHistoryEntry decodedTransactionHistoryEntry = new TransactionHistoryEntry();
    decodedTransactionHistoryEntry.ledgerSeq = Uint32.decode(stream);
    decodedTransactionHistoryEntry.txSet = TransactionSet.decode(stream);
    decodedTransactionHistoryEntry.ext = TransactionHistoryEntryExt.decode(stream);
    return decodedTransactionHistoryEntry;
  }

  public static TransactionHistoryEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionHistoryEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * TransactionHistoryEntryExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     case 1:
   *         GeneralizedTransactionSet generalizedTxSet;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TransactionHistoryEntryExt implements XdrElement {
    private Integer discriminant;
    private GeneralizedTransactionSet generalizedTxSet;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 1:
          generalizedTxSet.encode(stream);
          break;
      }
    }

    public static TransactionHistoryEntryExt decode(XdrDataInputStream stream) throws IOException {
      TransactionHistoryEntryExt decodedTransactionHistoryEntryExt =
          new TransactionHistoryEntryExt();
      Integer discriminant = stream.readInt();
      decodedTransactionHistoryEntryExt.setDiscriminant(discriminant);
      switch (decodedTransactionHistoryEntryExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedTransactionHistoryEntryExt.generalizedTxSet =
              GeneralizedTransactionSet.decode(stream);
          break;
      }
      return decodedTransactionHistoryEntryExt;
    }

    public static TransactionHistoryEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TransactionHistoryEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
