// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionSignaturePayload's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionSignaturePayload
 * {
 *     Hash networkId;
 *     union switch (EnvelopeType type)
 *     {
 *     // Backwards Compatibility: Use ENVELOPE_TYPE_TX to sign ENVELOPE_TYPE_TX_V0
 *     case ENVELOPE_TYPE_TX:
 *         Transaction tx;
 *     case ENVELOPE_TYPE_TX_FEE_BUMP:
 *         FeeBumpTransaction feeBump;
 *     }
 *     taggedTransaction;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionSignaturePayload implements XdrElement {
  private Hash networkId;
  private TransactionSignaturePayloadTaggedTransaction taggedTransaction;

  public void encode(XdrDataOutputStream stream) throws IOException {
    networkId.encode(stream);
    taggedTransaction.encode(stream);
  }

  public static TransactionSignaturePayload decode(XdrDataInputStream stream) throws IOException {
    TransactionSignaturePayload decodedTransactionSignaturePayload =
        new TransactionSignaturePayload();
    decodedTransactionSignaturePayload.networkId = Hash.decode(stream);
    decodedTransactionSignaturePayload.taggedTransaction =
        TransactionSignaturePayloadTaggedTransaction.decode(stream);
    return decodedTransactionSignaturePayload;
  }

  public static TransactionSignaturePayload fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionSignaturePayload fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * TransactionSignaturePayloadTaggedTransaction's original definition in the XDR file is:
   *
   * <pre>
   * union switch (EnvelopeType type)
   *     {
   *     // Backwards Compatibility: Use ENVELOPE_TYPE_TX to sign ENVELOPE_TYPE_TX_V0
   *     case ENVELOPE_TYPE_TX:
   *         Transaction tx;
   *     case ENVELOPE_TYPE_TX_FEE_BUMP:
   *         FeeBumpTransaction feeBump;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TransactionSignaturePayloadTaggedTransaction implements XdrElement {
    private EnvelopeType discriminant;
    private Transaction tx;
    private FeeBumpTransaction feeBump;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case ENVELOPE_TYPE_TX:
          tx.encode(stream);
          break;
        case ENVELOPE_TYPE_TX_FEE_BUMP:
          feeBump.encode(stream);
          break;
      }
    }

    public static TransactionSignaturePayloadTaggedTransaction decode(XdrDataInputStream stream)
        throws IOException {
      TransactionSignaturePayloadTaggedTransaction
          decodedTransactionSignaturePayloadTaggedTransaction =
              new TransactionSignaturePayloadTaggedTransaction();
      EnvelopeType discriminant = EnvelopeType.decode(stream);
      decodedTransactionSignaturePayloadTaggedTransaction.setDiscriminant(discriminant);
      switch (decodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant()) {
        case ENVELOPE_TYPE_TX:
          decodedTransactionSignaturePayloadTaggedTransaction.tx = Transaction.decode(stream);
          break;
        case ENVELOPE_TYPE_TX_FEE_BUMP:
          decodedTransactionSignaturePayloadTaggedTransaction.feeBump =
              FeeBumpTransaction.decode(stream);
          break;
      }
      return decodedTransactionSignaturePayloadTaggedTransaction;
    }

    public static TransactionSignaturePayloadTaggedTransaction fromXdrBase64(String xdr)
        throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TransactionSignaturePayloadTaggedTransaction fromXdrByteArray(byte[] xdr)
        throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
