// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TrustLineAsset's original definition in the XDR file is:
 *
 * <pre>
 * union TrustLineAsset switch (AssetType type)
 * {
 * case ASSET_TYPE_NATIVE: // Not credit
 *     void;
 *
 * case ASSET_TYPE_CREDIT_ALPHANUM4:
 *     AlphaNum4 alphaNum4;
 *
 * case ASSET_TYPE_CREDIT_ALPHANUM12:
 *     AlphaNum12 alphaNum12;
 *
 * case ASSET_TYPE_POOL_SHARE:
 *     PoolID liquidityPoolID;
 *
 *     // add other asset types here in the future
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TrustLineAsset implements XdrElement {
  private AssetType discriminant;
  private AlphaNum4 alphaNum4;
  private AlphaNum12 alphaNum12;
  private PoolID liquidityPoolID;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ASSET_TYPE_NATIVE:
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        alphaNum4.encode(stream);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        alphaNum12.encode(stream);
        break;
      case ASSET_TYPE_POOL_SHARE:
        liquidityPoolID.encode(stream);
        break;
    }
  }

  public static TrustLineAsset decode(XdrDataInputStream stream) throws IOException {
    TrustLineAsset decodedTrustLineAsset = new TrustLineAsset();
    AssetType discriminant = AssetType.decode(stream);
    decodedTrustLineAsset.setDiscriminant(discriminant);
    switch (decodedTrustLineAsset.getDiscriminant()) {
      case ASSET_TYPE_NATIVE:
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        decodedTrustLineAsset.alphaNum4 = AlphaNum4.decode(stream);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        decodedTrustLineAsset.alphaNum12 = AlphaNum12.decode(stream);
        break;
      case ASSET_TYPE_POOL_SHARE:
        decodedTrustLineAsset.liquidityPoolID = PoolID.decode(stream);
        break;
    }
    return decodedTrustLineAsset;
  }

  public static TrustLineAsset fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TrustLineAsset fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
