/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.PublicKey;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Uint256;

public class SignedPayloadSigner {
    public static final int SIGNED_PAYLOAD_MAX_PAYLOAD_LENGTH = 64;
    private final AccountID signerAccountId;
    private final byte[] payload;

    public SignedPayloadSigner(@NonNull AccountID signerAccountId, byte @NonNull [] payload) {
        if (signerAccountId == null) {
            throw new NullPointerException("signerAccountId is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (payload.length > 64) {
            throw new IllegalArgumentException("invalid payload length, must be less than 64");
        }
        if (signerAccountId.getAccountID().getDiscriminant() == null || !signerAccountId.getAccountID().getDiscriminant().equals(PublicKeyType.PUBLIC_KEY_TYPE_ED25519)) {
            throw new IllegalArgumentException("invalid payload signer, only ED25519 public key accounts are supported currently");
        }
        this.signerAccountId = signerAccountId;
        this.payload = payload;
    }

    public SignedPayloadSigner(byte[] signerED25519PublicKey, byte[] payload) {
        this(new AccountID(PublicKey.builder().discriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519).ed25519(new Uint256(signerED25519PublicKey)).build()), payload);
    }

    @Generated
    public AccountID getSignerAccountId() {
        return this.signerAccountId;
    }

    @Generated
    public byte[] getPayload() {
        return this.payload;
    }

    @Generated
    public String toString() {
        return "SignedPayloadSigner(signerAccountId=" + this.getSignerAccountId() + ", payload=" + Arrays.toString(this.getPayload()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedPayloadSigner)) {
            return false;
        }
        SignedPayloadSigner other = (SignedPayloadSigner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$signerAccountId = this.getSignerAccountId();
        AccountID other$signerAccountId = other.getSignerAccountId();
        if (this$signerAccountId == null ? other$signerAccountId != null : !((Object)this$signerAccountId).equals(other$signerAccountId)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignedPayloadSigner;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $signerAccountId = this.getSignerAccountId();
        result = result * 59 + ($signerAccountId == null ? 43 : ((Object)$signerAccountId).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }
}

