/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerHeaderFlags implements XdrElement
{
    DISABLE_LIQUIDITY_POOL_TRADING_FLAG(1),
    DISABLE_LIQUIDITY_POOL_DEPOSIT_FLAG(2),
    DISABLE_LIQUIDITY_POOL_WITHDRAWAL_FLAG(4);

    private final int value;

    private LedgerHeaderFlags(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LedgerHeaderFlags decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return DISABLE_LIQUIDITY_POOL_TRADING_FLAG;
            }
            case 2: {
                return DISABLE_LIQUIDITY_POOL_DEPOSIT_FLAG;
            }
            case 4: {
                return DISABLE_LIQUIDITY_POOL_WITHDRAWAL_FLAG;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static LedgerHeaderFlags fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerHeaderFlags.fromXdrByteArray(bytes);
    }

    public static LedgerHeaderFlags fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerHeaderFlags.decode(xdrDataInputStream);
    }
}

