/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PathPaymentStrictSendOp
implements XdrElement {
    private Asset sendAsset;
    private Int64 sendAmount;
    private MuxedAccount destination;
    private Asset destAsset;
    private Int64 destMin;
    private Asset[] path;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.sendAsset.encode(stream);
        this.sendAmount.encode(stream);
        this.destination.encode(stream);
        this.destAsset.encode(stream);
        this.destMin.encode(stream);
        int pathSize = this.getPath().length;
        stream.writeInt(pathSize);
        for (int i = 0; i < pathSize; ++i) {
            this.path[i].encode(stream);
        }
    }

    public static PathPaymentStrictSendOp decode(XdrDataInputStream stream) throws IOException {
        PathPaymentStrictSendOp decodedPathPaymentStrictSendOp = new PathPaymentStrictSendOp();
        decodedPathPaymentStrictSendOp.sendAsset = Asset.decode(stream);
        decodedPathPaymentStrictSendOp.sendAmount = Int64.decode(stream);
        decodedPathPaymentStrictSendOp.destination = MuxedAccount.decode(stream);
        decodedPathPaymentStrictSendOp.destAsset = Asset.decode(stream);
        decodedPathPaymentStrictSendOp.destMin = Int64.decode(stream);
        int pathSize = stream.readInt();
        decodedPathPaymentStrictSendOp.path = new Asset[pathSize];
        for (int i = 0; i < pathSize; ++i) {
            decodedPathPaymentStrictSendOp.path[i] = Asset.decode(stream);
        }
        return decodedPathPaymentStrictSendOp;
    }

    public static PathPaymentStrictSendOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PathPaymentStrictSendOp.fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictSendOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PathPaymentStrictSendOp.decode(xdrDataInputStream);
    }

    @Generated
    public static PathPaymentStrictSendOpBuilder builder() {
        return new PathPaymentStrictSendOpBuilder();
    }

    @Generated
    public PathPaymentStrictSendOpBuilder toBuilder() {
        return new PathPaymentStrictSendOpBuilder().sendAsset(this.sendAsset).sendAmount(this.sendAmount).destination(this.destination).destAsset(this.destAsset).destMin(this.destMin).path(this.path);
    }

    @Generated
    public Asset getSendAsset() {
        return this.sendAsset;
    }

    @Generated
    public Int64 getSendAmount() {
        return this.sendAmount;
    }

    @Generated
    public MuxedAccount getDestination() {
        return this.destination;
    }

    @Generated
    public Asset getDestAsset() {
        return this.destAsset;
    }

    @Generated
    public Int64 getDestMin() {
        return this.destMin;
    }

    @Generated
    public Asset[] getPath() {
        return this.path;
    }

    @Generated
    public void setSendAsset(Asset sendAsset) {
        this.sendAsset = sendAsset;
    }

    @Generated
    public void setSendAmount(Int64 sendAmount) {
        this.sendAmount = sendAmount;
    }

    @Generated
    public void setDestination(MuxedAccount destination) {
        this.destination = destination;
    }

    @Generated
    public void setDestAsset(Asset destAsset) {
        this.destAsset = destAsset;
    }

    @Generated
    public void setDestMin(Int64 destMin) {
        this.destMin = destMin;
    }

    @Generated
    public void setPath(Asset[] path) {
        this.path = path;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictSendOp)) {
            return false;
        }
        PathPaymentStrictSendOp other = (PathPaymentStrictSendOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Asset this$sendAsset = this.getSendAsset();
        Asset other$sendAsset = other.getSendAsset();
        if (this$sendAsset == null ? other$sendAsset != null : !((Object)this$sendAsset).equals(other$sendAsset)) {
            return false;
        }
        Int64 this$sendAmount = this.getSendAmount();
        Int64 other$sendAmount = other.getSendAmount();
        if (this$sendAmount == null ? other$sendAmount != null : !((Object)this$sendAmount).equals(other$sendAmount)) {
            return false;
        }
        MuxedAccount this$destination = this.getDestination();
        MuxedAccount other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        Asset this$destAsset = this.getDestAsset();
        Asset other$destAsset = other.getDestAsset();
        if (this$destAsset == null ? other$destAsset != null : !((Object)this$destAsset).equals(other$destAsset)) {
            return false;
        }
        Int64 this$destMin = this.getDestMin();
        Int64 other$destMin = other.getDestMin();
        if (this$destMin == null ? other$destMin != null : !((Object)this$destMin).equals(other$destMin)) {
            return false;
        }
        return Arrays.deepEquals(this.getPath(), other.getPath());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictSendOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asset $sendAsset = this.getSendAsset();
        result = result * 59 + ($sendAsset == null ? 43 : ((Object)$sendAsset).hashCode());
        Int64 $sendAmount = this.getSendAmount();
        result = result * 59 + ($sendAmount == null ? 43 : ((Object)$sendAmount).hashCode());
        MuxedAccount $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        Asset $destAsset = this.getDestAsset();
        result = result * 59 + ($destAsset == null ? 43 : ((Object)$destAsset).hashCode());
        Int64 $destMin = this.getDestMin();
        result = result * 59 + ($destMin == null ? 43 : ((Object)$destMin).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        return result;
    }

    @Generated
    public String toString() {
        return "PathPaymentStrictSendOp(sendAsset=" + this.getSendAsset() + ", sendAmount=" + this.getSendAmount() + ", destination=" + this.getDestination() + ", destAsset=" + this.getDestAsset() + ", destMin=" + this.getDestMin() + ", path=" + Arrays.deepToString(this.getPath()) + ")";
    }

    @Generated
    public PathPaymentStrictSendOp() {
    }

    @Generated
    public PathPaymentStrictSendOp(Asset sendAsset, Int64 sendAmount, MuxedAccount destination, Asset destAsset, Int64 destMin, Asset[] path) {
        this.sendAsset = sendAsset;
        this.sendAmount = sendAmount;
        this.destination = destination;
        this.destAsset = destAsset;
        this.destMin = destMin;
        this.path = path;
    }

    @Generated
    public static class PathPaymentStrictSendOpBuilder {
        @Generated
        private Asset sendAsset;
        @Generated
        private Int64 sendAmount;
        @Generated
        private MuxedAccount destination;
        @Generated
        private Asset destAsset;
        @Generated
        private Int64 destMin;
        @Generated
        private Asset[] path;

        @Generated
        PathPaymentStrictSendOpBuilder() {
        }

        @Generated
        public PathPaymentStrictSendOpBuilder sendAsset(Asset sendAsset) {
            this.sendAsset = sendAsset;
            return this;
        }

        @Generated
        public PathPaymentStrictSendOpBuilder sendAmount(Int64 sendAmount) {
            this.sendAmount = sendAmount;
            return this;
        }

        @Generated
        public PathPaymentStrictSendOpBuilder destination(MuxedAccount destination) {
            this.destination = destination;
            return this;
        }

        @Generated
        public PathPaymentStrictSendOpBuilder destAsset(Asset destAsset) {
            this.destAsset = destAsset;
            return this;
        }

        @Generated
        public PathPaymentStrictSendOpBuilder destMin(Int64 destMin) {
            this.destMin = destMin;
            return this;
        }

        @Generated
        public PathPaymentStrictSendOpBuilder path(Asset[] path) {
            this.path = path;
            return this;
        }

        @Generated
        public PathPaymentStrictSendOp build() {
            return new PathPaymentStrictSendOp(this.sendAsset, this.sendAmount, this.destination, this.destAsset, this.destMin, this.path);
        }

        @Generated
        public String toString() {
            return "PathPaymentStrictSendOp.PathPaymentStrictSendOpBuilder(sendAsset=" + this.sendAsset + ", sendAmount=" + this.sendAmount + ", destination=" + this.destination + ", destAsset=" + this.destAsset + ", destMin=" + this.destMin + ", path=" + Arrays.deepToString(this.path) + ")";
        }
    }
}

