/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCErrorType implements XdrElement
{
    SCE_CONTRACT(0),
    SCE_WASM_VM(1),
    SCE_CONTEXT(2),
    SCE_STORAGE(3),
    SCE_OBJECT(4),
    SCE_CRYPTO(5),
    SCE_EVENTS(6),
    SCE_BUDGET(7),
    SCE_VALUE(8),
    SCE_AUTH(9);

    private final int value;

    private SCErrorType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SCErrorType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SCE_CONTRACT;
            }
            case 1: {
                return SCE_WASM_VM;
            }
            case 2: {
                return SCE_CONTEXT;
            }
            case 3: {
                return SCE_STORAGE;
            }
            case 4: {
                return SCE_OBJECT;
            }
            case 5: {
                return SCE_CRYPTO;
            }
            case 6: {
                return SCE_EVENTS;
            }
            case 7: {
                return SCE_BUDGET;
            }
            case 8: {
                return SCE_VALUE;
            }
            case 9: {
                return SCE_AUTH;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SCErrorType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCErrorType.fromXdrByteArray(bytes);
    }

    public static SCErrorType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCErrorType.decode(xdrDataInputStream);
    }
}

