/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PeerStatList;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TopologyResponseBodyV0
implements XdrElement {
    private PeerStatList inboundPeers;
    private PeerStatList outboundPeers;
    private Uint32 totalInboundPeerCount;
    private Uint32 totalOutboundPeerCount;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.inboundPeers.encode(stream);
        this.outboundPeers.encode(stream);
        this.totalInboundPeerCount.encode(stream);
        this.totalOutboundPeerCount.encode(stream);
    }

    public static TopologyResponseBodyV0 decode(XdrDataInputStream stream) throws IOException {
        TopologyResponseBodyV0 decodedTopologyResponseBodyV0 = new TopologyResponseBodyV0();
        decodedTopologyResponseBodyV0.inboundPeers = PeerStatList.decode(stream);
        decodedTopologyResponseBodyV0.outboundPeers = PeerStatList.decode(stream);
        decodedTopologyResponseBodyV0.totalInboundPeerCount = Uint32.decode(stream);
        decodedTopologyResponseBodyV0.totalOutboundPeerCount = Uint32.decode(stream);
        return decodedTopologyResponseBodyV0;
    }

    public static TopologyResponseBodyV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TopologyResponseBodyV0.fromXdrByteArray(bytes);
    }

    public static TopologyResponseBodyV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TopologyResponseBodyV0.decode(xdrDataInputStream);
    }

    @Generated
    public static TopologyResponseBodyV0Builder builder() {
        return new TopologyResponseBodyV0Builder();
    }

    @Generated
    public TopologyResponseBodyV0Builder toBuilder() {
        return new TopologyResponseBodyV0Builder().inboundPeers(this.inboundPeers).outboundPeers(this.outboundPeers).totalInboundPeerCount(this.totalInboundPeerCount).totalOutboundPeerCount(this.totalOutboundPeerCount);
    }

    @Generated
    public PeerStatList getInboundPeers() {
        return this.inboundPeers;
    }

    @Generated
    public PeerStatList getOutboundPeers() {
        return this.outboundPeers;
    }

    @Generated
    public Uint32 getTotalInboundPeerCount() {
        return this.totalInboundPeerCount;
    }

    @Generated
    public Uint32 getTotalOutboundPeerCount() {
        return this.totalOutboundPeerCount;
    }

    @Generated
    public void setInboundPeers(PeerStatList inboundPeers) {
        this.inboundPeers = inboundPeers;
    }

    @Generated
    public void setOutboundPeers(PeerStatList outboundPeers) {
        this.outboundPeers = outboundPeers;
    }

    @Generated
    public void setTotalInboundPeerCount(Uint32 totalInboundPeerCount) {
        this.totalInboundPeerCount = totalInboundPeerCount;
    }

    @Generated
    public void setTotalOutboundPeerCount(Uint32 totalOutboundPeerCount) {
        this.totalOutboundPeerCount = totalOutboundPeerCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopologyResponseBodyV0)) {
            return false;
        }
        TopologyResponseBodyV0 other = (TopologyResponseBodyV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PeerStatList this$inboundPeers = this.getInboundPeers();
        PeerStatList other$inboundPeers = other.getInboundPeers();
        if (this$inboundPeers == null ? other$inboundPeers != null : !((Object)this$inboundPeers).equals(other$inboundPeers)) {
            return false;
        }
        PeerStatList this$outboundPeers = this.getOutboundPeers();
        PeerStatList other$outboundPeers = other.getOutboundPeers();
        if (this$outboundPeers == null ? other$outboundPeers != null : !((Object)this$outboundPeers).equals(other$outboundPeers)) {
            return false;
        }
        Uint32 this$totalInboundPeerCount = this.getTotalInboundPeerCount();
        Uint32 other$totalInboundPeerCount = other.getTotalInboundPeerCount();
        if (this$totalInboundPeerCount == null ? other$totalInboundPeerCount != null : !((Object)this$totalInboundPeerCount).equals(other$totalInboundPeerCount)) {
            return false;
        }
        Uint32 this$totalOutboundPeerCount = this.getTotalOutboundPeerCount();
        Uint32 other$totalOutboundPeerCount = other.getTotalOutboundPeerCount();
        return !(this$totalOutboundPeerCount == null ? other$totalOutboundPeerCount != null : !((Object)this$totalOutboundPeerCount).equals(other$totalOutboundPeerCount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopologyResponseBodyV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PeerStatList $inboundPeers = this.getInboundPeers();
        result = result * 59 + ($inboundPeers == null ? 43 : ((Object)$inboundPeers).hashCode());
        PeerStatList $outboundPeers = this.getOutboundPeers();
        result = result * 59 + ($outboundPeers == null ? 43 : ((Object)$outboundPeers).hashCode());
        Uint32 $totalInboundPeerCount = this.getTotalInboundPeerCount();
        result = result * 59 + ($totalInboundPeerCount == null ? 43 : ((Object)$totalInboundPeerCount).hashCode());
        Uint32 $totalOutboundPeerCount = this.getTotalOutboundPeerCount();
        result = result * 59 + ($totalOutboundPeerCount == null ? 43 : ((Object)$totalOutboundPeerCount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TopologyResponseBodyV0(inboundPeers=" + this.getInboundPeers() + ", outboundPeers=" + this.getOutboundPeers() + ", totalInboundPeerCount=" + this.getTotalInboundPeerCount() + ", totalOutboundPeerCount=" + this.getTotalOutboundPeerCount() + ")";
    }

    @Generated
    public TopologyResponseBodyV0() {
    }

    @Generated
    public TopologyResponseBodyV0(PeerStatList inboundPeers, PeerStatList outboundPeers, Uint32 totalInboundPeerCount, Uint32 totalOutboundPeerCount) {
        this.inboundPeers = inboundPeers;
        this.outboundPeers = outboundPeers;
        this.totalInboundPeerCount = totalInboundPeerCount;
        this.totalOutboundPeerCount = totalOutboundPeerCount;
    }

    @Generated
    public static class TopologyResponseBodyV0Builder {
        @Generated
        private PeerStatList inboundPeers;
        @Generated
        private PeerStatList outboundPeers;
        @Generated
        private Uint32 totalInboundPeerCount;
        @Generated
        private Uint32 totalOutboundPeerCount;

        @Generated
        TopologyResponseBodyV0Builder() {
        }

        @Generated
        public TopologyResponseBodyV0Builder inboundPeers(PeerStatList inboundPeers) {
            this.inboundPeers = inboundPeers;
            return this;
        }

        @Generated
        public TopologyResponseBodyV0Builder outboundPeers(PeerStatList outboundPeers) {
            this.outboundPeers = outboundPeers;
            return this;
        }

        @Generated
        public TopologyResponseBodyV0Builder totalInboundPeerCount(Uint32 totalInboundPeerCount) {
            this.totalInboundPeerCount = totalInboundPeerCount;
            return this;
        }

        @Generated
        public TopologyResponseBodyV0Builder totalOutboundPeerCount(Uint32 totalOutboundPeerCount) {
            this.totalOutboundPeerCount = totalOutboundPeerCount;
            return this;
        }

        @Generated
        public TopologyResponseBodyV0 build() {
            return new TopologyResponseBodyV0(this.inboundPeers, this.outboundPeers, this.totalInboundPeerCount, this.totalOutboundPeerCount);
        }

        @Generated
        public String toString() {
            return "TopologyResponseBodyV0.TopologyResponseBodyV0Builder(inboundPeers=" + this.inboundPeers + ", outboundPeers=" + this.outboundPeers + ", totalInboundPeerCount=" + this.totalInboundPeerCount + ", totalOutboundPeerCount=" + this.totalOutboundPeerCount + ")";
        }
    }
}

