/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TxSetComponentType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TxSetComponent
implements XdrElement {
    private TxSetComponentType discriminant;
    private TxSetComponentTxsMaybeDiscountedFee txsMaybeDiscountedFee;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case TXSET_COMP_TXS_MAYBE_DISCOUNTED_FEE: {
                this.txsMaybeDiscountedFee.encode(stream);
            }
        }
    }

    public static TxSetComponent decode(XdrDataInputStream stream) throws IOException {
        TxSetComponent decodedTxSetComponent = new TxSetComponent();
        TxSetComponentType discriminant = TxSetComponentType.decode(stream);
        decodedTxSetComponent.setDiscriminant(discriminant);
        switch (decodedTxSetComponent.getDiscriminant()) {
            case TXSET_COMP_TXS_MAYBE_DISCOUNTED_FEE: {
                decodedTxSetComponent.txsMaybeDiscountedFee = TxSetComponentTxsMaybeDiscountedFee.decode(stream);
            }
        }
        return decodedTxSetComponent;
    }

    public static TxSetComponent fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TxSetComponent.fromXdrByteArray(bytes);
    }

    public static TxSetComponent fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TxSetComponent.decode(xdrDataInputStream);
    }

    @Generated
    public static TxSetComponentBuilder builder() {
        return new TxSetComponentBuilder();
    }

    @Generated
    public TxSetComponentBuilder toBuilder() {
        return new TxSetComponentBuilder().discriminant(this.discriminant).txsMaybeDiscountedFee(this.txsMaybeDiscountedFee);
    }

    @Generated
    public TxSetComponentType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public TxSetComponentTxsMaybeDiscountedFee getTxsMaybeDiscountedFee() {
        return this.txsMaybeDiscountedFee;
    }

    @Generated
    public void setDiscriminant(TxSetComponentType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setTxsMaybeDiscountedFee(TxSetComponentTxsMaybeDiscountedFee txsMaybeDiscountedFee) {
        this.txsMaybeDiscountedFee = txsMaybeDiscountedFee;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxSetComponent)) {
            return false;
        }
        TxSetComponent other = (TxSetComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TxSetComponentType this$discriminant = this.getDiscriminant();
        TxSetComponentType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        TxSetComponentTxsMaybeDiscountedFee this$txsMaybeDiscountedFee = this.getTxsMaybeDiscountedFee();
        TxSetComponentTxsMaybeDiscountedFee other$txsMaybeDiscountedFee = other.getTxsMaybeDiscountedFee();
        return !(this$txsMaybeDiscountedFee == null ? other$txsMaybeDiscountedFee != null : !((Object)this$txsMaybeDiscountedFee).equals(other$txsMaybeDiscountedFee));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TxSetComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TxSetComponentType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        TxSetComponentTxsMaybeDiscountedFee $txsMaybeDiscountedFee = this.getTxsMaybeDiscountedFee();
        result = result * 59 + ($txsMaybeDiscountedFee == null ? 43 : ((Object)$txsMaybeDiscountedFee).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TxSetComponent(discriminant=" + this.getDiscriminant() + ", txsMaybeDiscountedFee=" + this.getTxsMaybeDiscountedFee() + ")";
    }

    @Generated
    public TxSetComponent() {
    }

    @Generated
    public TxSetComponent(TxSetComponentType discriminant, TxSetComponentTxsMaybeDiscountedFee txsMaybeDiscountedFee) {
        this.discriminant = discriminant;
        this.txsMaybeDiscountedFee = txsMaybeDiscountedFee;
    }

    public static class TxSetComponentTxsMaybeDiscountedFee
    implements XdrElement {
        private Int64 baseFee;
        private TransactionEnvelope[] txs;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            if (this.baseFee != null) {
                stream.writeInt(1);
                this.baseFee.encode(stream);
            } else {
                stream.writeInt(0);
            }
            int txsSize = this.getTxs().length;
            stream.writeInt(txsSize);
            for (int i = 0; i < txsSize; ++i) {
                this.txs[i].encode(stream);
            }
        }

        public static TxSetComponentTxsMaybeDiscountedFee decode(XdrDataInputStream stream) throws IOException {
            TxSetComponentTxsMaybeDiscountedFee decodedTxSetComponentTxsMaybeDiscountedFee = new TxSetComponentTxsMaybeDiscountedFee();
            int baseFeePresent = stream.readInt();
            if (baseFeePresent != 0) {
                decodedTxSetComponentTxsMaybeDiscountedFee.baseFee = Int64.decode(stream);
            }
            int txsSize = stream.readInt();
            decodedTxSetComponentTxsMaybeDiscountedFee.txs = new TransactionEnvelope[txsSize];
            for (int i = 0; i < txsSize; ++i) {
                decodedTxSetComponentTxsMaybeDiscountedFee.txs[i] = TransactionEnvelope.decode(stream);
            }
            return decodedTxSetComponentTxsMaybeDiscountedFee;
        }

        public static TxSetComponentTxsMaybeDiscountedFee fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TxSetComponentTxsMaybeDiscountedFee.fromXdrByteArray(bytes);
        }

        public static TxSetComponentTxsMaybeDiscountedFee fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TxSetComponentTxsMaybeDiscountedFee.decode(xdrDataInputStream);
        }

        @Generated
        public static TxSetComponentTxsMaybeDiscountedFeeBuilder builder() {
            return new TxSetComponentTxsMaybeDiscountedFeeBuilder();
        }

        @Generated
        public TxSetComponentTxsMaybeDiscountedFeeBuilder toBuilder() {
            return new TxSetComponentTxsMaybeDiscountedFeeBuilder().baseFee(this.baseFee).txs(this.txs);
        }

        @Generated
        public Int64 getBaseFee() {
            return this.baseFee;
        }

        @Generated
        public TransactionEnvelope[] getTxs() {
            return this.txs;
        }

        @Generated
        public void setBaseFee(Int64 baseFee) {
            this.baseFee = baseFee;
        }

        @Generated
        public void setTxs(TransactionEnvelope[] txs) {
            this.txs = txs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TxSetComponentTxsMaybeDiscountedFee)) {
                return false;
            }
            TxSetComponentTxsMaybeDiscountedFee other = (TxSetComponentTxsMaybeDiscountedFee)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Int64 this$baseFee = this.getBaseFee();
            Int64 other$baseFee = other.getBaseFee();
            if (this$baseFee == null ? other$baseFee != null : !((Object)this$baseFee).equals(other$baseFee)) {
                return false;
            }
            return Arrays.deepEquals(this.getTxs(), other.getTxs());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TxSetComponentTxsMaybeDiscountedFee;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Int64 $baseFee = this.getBaseFee();
            result = result * 59 + ($baseFee == null ? 43 : ((Object)$baseFee).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getTxs());
            return result;
        }

        @Generated
        public String toString() {
            return "TxSetComponent.TxSetComponentTxsMaybeDiscountedFee(baseFee=" + this.getBaseFee() + ", txs=" + Arrays.deepToString(this.getTxs()) + ")";
        }

        @Generated
        public TxSetComponentTxsMaybeDiscountedFee() {
        }

        @Generated
        public TxSetComponentTxsMaybeDiscountedFee(Int64 baseFee, TransactionEnvelope[] txs) {
            this.baseFee = baseFee;
            this.txs = txs;
        }

        @Generated
        public static class TxSetComponentTxsMaybeDiscountedFeeBuilder {
            @Generated
            private Int64 baseFee;
            @Generated
            private TransactionEnvelope[] txs;

            @Generated
            TxSetComponentTxsMaybeDiscountedFeeBuilder() {
            }

            @Generated
            public TxSetComponentTxsMaybeDiscountedFeeBuilder baseFee(Int64 baseFee) {
                this.baseFee = baseFee;
                return this;
            }

            @Generated
            public TxSetComponentTxsMaybeDiscountedFeeBuilder txs(TransactionEnvelope[] txs) {
                this.txs = txs;
                return this;
            }

            @Generated
            public TxSetComponentTxsMaybeDiscountedFee build() {
                return new TxSetComponentTxsMaybeDiscountedFee(this.baseFee, this.txs);
            }

            @Generated
            public String toString() {
                return "TxSetComponent.TxSetComponentTxsMaybeDiscountedFee.TxSetComponentTxsMaybeDiscountedFeeBuilder(baseFee=" + this.baseFee + ", txs=" + Arrays.deepToString(this.txs) + ")";
            }
        }
    }

    @Generated
    public static class TxSetComponentBuilder {
        @Generated
        private TxSetComponentType discriminant;
        @Generated
        private TxSetComponentTxsMaybeDiscountedFee txsMaybeDiscountedFee;

        @Generated
        TxSetComponentBuilder() {
        }

        @Generated
        public TxSetComponentBuilder discriminant(TxSetComponentType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public TxSetComponentBuilder txsMaybeDiscountedFee(TxSetComponentTxsMaybeDiscountedFee txsMaybeDiscountedFee) {
            this.txsMaybeDiscountedFee = txsMaybeDiscountedFee;
            return this;
        }

        @Generated
        public TxSetComponent build() {
            return new TxSetComponent(this.discriminant, this.txsMaybeDiscountedFee);
        }

        @Generated
        public String toString() {
            return "TxSetComponent.TxSetComponentBuilder(discriminant=" + this.discriminant + ", txsMaybeDiscountedFee=" + this.txsMaybeDiscountedFee + ")";
        }
    }
}

