// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Int64's original definition in the XDR file is:
 *
 * <pre>
 * typedef hyper int64;
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Int64 implements XdrElement {
  private Long int64;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeLong(int64);
  }

  public static Int64 decode(XdrDataInputStream stream) throws IOException {
    Int64 decodedInt64 = new Int64();
    decodedInt64.int64 = stream.readLong();
    return decodedInt64;
  }

  public static Int64 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Int64 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
