// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerHeaderHistoryEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerHeaderHistoryEntry
 * {
 *     Hash hash;
 *     LedgerHeader header;
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerHeaderHistoryEntry implements XdrElement {
  private Hash hash;
  private LedgerHeader header;
  private LedgerHeaderHistoryEntryExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    hash.encode(stream);
    header.encode(stream);
    ext.encode(stream);
  }

  public static LedgerHeaderHistoryEntry decode(XdrDataInputStream stream) throws IOException {
    LedgerHeaderHistoryEntry decodedLedgerHeaderHistoryEntry = new LedgerHeaderHistoryEntry();
    decodedLedgerHeaderHistoryEntry.hash = Hash.decode(stream);
    decodedLedgerHeaderHistoryEntry.header = LedgerHeader.decode(stream);
    decodedLedgerHeaderHistoryEntry.ext = LedgerHeaderHistoryEntryExt.decode(stream);
    return decodedLedgerHeaderHistoryEntry;
  }

  public static LedgerHeaderHistoryEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerHeaderHistoryEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * LedgerHeaderHistoryEntryExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LedgerHeaderHistoryEntryExt implements XdrElement {
    private Integer discriminant;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
      }
    }

    public static LedgerHeaderHistoryEntryExt decode(XdrDataInputStream stream) throws IOException {
      LedgerHeaderHistoryEntryExt decodedLedgerHeaderHistoryEntryExt =
          new LedgerHeaderHistoryEntryExt();
      Integer discriminant = stream.readInt();
      decodedLedgerHeaderHistoryEntryExt.setDiscriminant(discriminant);
      switch (decodedLedgerHeaderHistoryEntryExt.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedLedgerHeaderHistoryEntryExt;
    }

    public static LedgerHeaderHistoryEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LedgerHeaderHistoryEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
