// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerSCPMessages's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerSCPMessages
 * {
 *     uint32 ledgerSeq;
 *     SCPEnvelope messages&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerSCPMessages implements XdrElement {
  private Uint32 ledgerSeq;
  private SCPEnvelope[] messages;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ledgerSeq.encode(stream);
    int messagesSize = getMessages().length;
    stream.writeInt(messagesSize);
    for (int i = 0; i < messagesSize; i++) {
      messages[i].encode(stream);
    }
  }

  public static LedgerSCPMessages decode(XdrDataInputStream stream) throws IOException {
    LedgerSCPMessages decodedLedgerSCPMessages = new LedgerSCPMessages();
    decodedLedgerSCPMessages.ledgerSeq = Uint32.decode(stream);
    int messagesSize = stream.readInt();
    decodedLedgerSCPMessages.messages = new SCPEnvelope[messagesSize];
    for (int i = 0; i < messagesSize; i++) {
      decodedLedgerSCPMessages.messages[i] = SCPEnvelope.decode(stream);
    }
    return decodedLedgerSCPMessages;
  }

  public static LedgerSCPMessages fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerSCPMessages fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
