// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LiquidityPoolEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct LiquidityPoolEntry
 * {
 *     PoolID liquidityPoolID;
 *
 *     union switch (LiquidityPoolType type)
 *     {
 *     case LIQUIDITY_POOL_CONSTANT_PRODUCT:
 *         struct
 *         {
 *             LiquidityPoolConstantProductParameters params;
 *
 *             int64 reserveA;        // amount of A in the pool
 *             int64 reserveB;        // amount of B in the pool
 *             int64 totalPoolShares; // total number of pool shares issued
 *             int64 poolSharesTrustLineCount; // number of trust lines for the
 *                                             // associated pool shares
 *         } constantProduct;
 *     }
 *     body;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LiquidityPoolEntry implements XdrElement {
  private PoolID liquidityPoolID;
  private LiquidityPoolEntryBody body;

  public void encode(XdrDataOutputStream stream) throws IOException {
    liquidityPoolID.encode(stream);
    body.encode(stream);
  }

  public static LiquidityPoolEntry decode(XdrDataInputStream stream) throws IOException {
    LiquidityPoolEntry decodedLiquidityPoolEntry = new LiquidityPoolEntry();
    decodedLiquidityPoolEntry.liquidityPoolID = PoolID.decode(stream);
    decodedLiquidityPoolEntry.body = LiquidityPoolEntryBody.decode(stream);
    return decodedLiquidityPoolEntry;
  }

  public static LiquidityPoolEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LiquidityPoolEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * LiquidityPoolEntryBody's original definition in the XDR file is:
   *
   * <pre>
   * union switch (LiquidityPoolType type)
   *     {
   *     case LIQUIDITY_POOL_CONSTANT_PRODUCT:
   *         struct
   *         {
   *             LiquidityPoolConstantProductParameters params;
   *
   *             int64 reserveA;        // amount of A in the pool
   *             int64 reserveB;        // amount of B in the pool
   *             int64 totalPoolShares; // total number of pool shares issued
   *             int64 poolSharesTrustLineCount; // number of trust lines for the
   *                                             // associated pool shares
   *         } constantProduct;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class LiquidityPoolEntryBody implements XdrElement {
    private LiquidityPoolType discriminant;
    private LiquidityPoolEntryConstantProduct constantProduct;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case LIQUIDITY_POOL_CONSTANT_PRODUCT:
          constantProduct.encode(stream);
          break;
      }
    }

    public static LiquidityPoolEntryBody decode(XdrDataInputStream stream) throws IOException {
      LiquidityPoolEntryBody decodedLiquidityPoolEntryBody = new LiquidityPoolEntryBody();
      LiquidityPoolType discriminant = LiquidityPoolType.decode(stream);
      decodedLiquidityPoolEntryBody.setDiscriminant(discriminant);
      switch (decodedLiquidityPoolEntryBody.getDiscriminant()) {
        case LIQUIDITY_POOL_CONSTANT_PRODUCT:
          decodedLiquidityPoolEntryBody.constantProduct =
              LiquidityPoolEntryConstantProduct.decode(stream);
          break;
      }
      return decodedLiquidityPoolEntryBody;
    }

    public static LiquidityPoolEntryBody fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static LiquidityPoolEntryBody fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    /**
     * LiquidityPoolEntryConstantProduct's original definition in the XDR file is:
     *
     * <pre>
     * struct
     *         {
     *             LiquidityPoolConstantProductParameters params;
     *
     *             int64 reserveA;        // amount of A in the pool
     *             int64 reserveB;        // amount of B in the pool
     *             int64 totalPoolShares; // total number of pool shares issued
     *             int64 poolSharesTrustLineCount; // number of trust lines for the
     *                                             // associated pool shares
     *         }
     * </pre>
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class LiquidityPoolEntryConstantProduct implements XdrElement {
      private LiquidityPoolConstantProductParameters params;
      private Int64 reserveA;
      private Int64 reserveB;
      private Int64 totalPoolShares;
      private Int64 poolSharesTrustLineCount;

      public void encode(XdrDataOutputStream stream) throws IOException {
        params.encode(stream);
        reserveA.encode(stream);
        reserveB.encode(stream);
        totalPoolShares.encode(stream);
        poolSharesTrustLineCount.encode(stream);
      }

      public static LiquidityPoolEntryConstantProduct decode(XdrDataInputStream stream)
          throws IOException {
        LiquidityPoolEntryConstantProduct decodedLiquidityPoolEntryConstantProduct =
            new LiquidityPoolEntryConstantProduct();
        decodedLiquidityPoolEntryConstantProduct.params =
            LiquidityPoolConstantProductParameters.decode(stream);
        decodedLiquidityPoolEntryConstantProduct.reserveA = Int64.decode(stream);
        decodedLiquidityPoolEntryConstantProduct.reserveB = Int64.decode(stream);
        decodedLiquidityPoolEntryConstantProduct.totalPoolShares = Int64.decode(stream);
        decodedLiquidityPoolEntryConstantProduct.poolSharesTrustLineCount = Int64.decode(stream);
        return decodedLiquidityPoolEntryConstantProduct;
      }

      public static LiquidityPoolEntryConstantProduct fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return fromXdrByteArray(bytes);
      }

      public static LiquidityPoolEntryConstantProduct fromXdrByteArray(byte[] xdr)
          throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return decode(xdrDataInputStream);
      }
    }
  }
}
