// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * MuxedAccount's original definition in the XDR file is:
 *
 * <pre>
 * union MuxedAccount switch (CryptoKeyType type)
 * {
 * case KEY_TYPE_ED25519:
 *     uint256 ed25519;
 * case KEY_TYPE_MUXED_ED25519:
 *     struct
 *     {
 *         uint64 id;
 *         uint256 ed25519;
 *     } med25519;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class MuxedAccount implements XdrElement {
  private CryptoKeyType discriminant;
  private Uint256 ed25519;
  private MuxedAccountMed25519 med25519;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case KEY_TYPE_ED25519:
        ed25519.encode(stream);
        break;
      case KEY_TYPE_MUXED_ED25519:
        med25519.encode(stream);
        break;
    }
  }

  public static MuxedAccount decode(XdrDataInputStream stream) throws IOException {
    MuxedAccount decodedMuxedAccount = new MuxedAccount();
    CryptoKeyType discriminant = CryptoKeyType.decode(stream);
    decodedMuxedAccount.setDiscriminant(discriminant);
    switch (decodedMuxedAccount.getDiscriminant()) {
      case KEY_TYPE_ED25519:
        decodedMuxedAccount.ed25519 = Uint256.decode(stream);
        break;
      case KEY_TYPE_MUXED_ED25519:
        decodedMuxedAccount.med25519 = MuxedAccountMed25519.decode(stream);
        break;
    }
    return decodedMuxedAccount;
  }

  public static MuxedAccount fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static MuxedAccount fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * MuxedAccountMed25519's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         uint64 id;
   *         uint256 ed25519;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class MuxedAccountMed25519 implements XdrElement {
    private Uint64 id;
    private Uint256 ed25519;

    public void encode(XdrDataOutputStream stream) throws IOException {
      id.encode(stream);
      ed25519.encode(stream);
    }

    public static MuxedAccountMed25519 decode(XdrDataInputStream stream) throws IOException {
      MuxedAccountMed25519 decodedMuxedAccountMed25519 = new MuxedAccountMed25519();
      decodedMuxedAccountMed25519.id = Uint64.decode(stream);
      decodedMuxedAccountMed25519.ed25519 = Uint256.decode(stream);
      return decodedMuxedAccountMed25519;
    }

    public static MuxedAccountMed25519 fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static MuxedAccountMed25519 fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
