// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PreconditionsV2's original definition in the XDR file is:
 *
 * <pre>
 * struct PreconditionsV2
 * {
 *     TimeBounds&#42; timeBounds;
 *
 *     // Transaction only valid for ledger numbers n such that
 *     // minLedger &lt;= n &lt; maxLedger (if maxLedger == 0, then
 *     // only minLedger is checked)
 *     LedgerBounds&#42; ledgerBounds;
 *
 *     // If NULL, only valid when sourceAccount's sequence number
 *     // is seqNum - 1.  Otherwise, valid when sourceAccount's
 *     // sequence number n satisfies minSeqNum &lt;= n &lt; tx.seqNum.
 *     // Note that after execution the account's sequence number
 *     // is always raised to tx.seqNum, and a transaction is not
 *     // valid if tx.seqNum is too high to ensure replay protection.
 *     SequenceNumber&#42; minSeqNum;
 *
 *     // For the transaction to be valid, the current ledger time must
 *     // be at least minSeqAge greater than sourceAccount's seqTime.
 *     Duration minSeqAge;
 *
 *     // For the transaction to be valid, the current ledger number
 *     // must be at least minSeqLedgerGap greater than sourceAccount's
 *     // seqLedger.
 *     uint32 minSeqLedgerGap;
 *
 *     // For the transaction to be valid, there must be a signature
 *     // corresponding to every Signer in this array, even if the
 *     // signature is not otherwise required by the sourceAccount or
 *     // operations.
 *     SignerKey extraSigners&lt;2&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PreconditionsV2 implements XdrElement {
  private TimeBounds timeBounds;
  private LedgerBounds ledgerBounds;
  private SequenceNumber minSeqNum;
  private Duration minSeqAge;
  private Uint32 minSeqLedgerGap;
  private SignerKey[] extraSigners;

  public void encode(XdrDataOutputStream stream) throws IOException {
    if (timeBounds != null) {
      stream.writeInt(1);
      timeBounds.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (ledgerBounds != null) {
      stream.writeInt(1);
      ledgerBounds.encode(stream);
    } else {
      stream.writeInt(0);
    }
    if (minSeqNum != null) {
      stream.writeInt(1);
      minSeqNum.encode(stream);
    } else {
      stream.writeInt(0);
    }
    minSeqAge.encode(stream);
    minSeqLedgerGap.encode(stream);
    int extraSignersSize = getExtraSigners().length;
    stream.writeInt(extraSignersSize);
    for (int i = 0; i < extraSignersSize; i++) {
      extraSigners[i].encode(stream);
    }
  }

  public static PreconditionsV2 decode(XdrDataInputStream stream) throws IOException {
    PreconditionsV2 decodedPreconditionsV2 = new PreconditionsV2();
    int timeBoundsPresent = stream.readInt();
    if (timeBoundsPresent != 0) {
      decodedPreconditionsV2.timeBounds = TimeBounds.decode(stream);
    }
    int ledgerBoundsPresent = stream.readInt();
    if (ledgerBoundsPresent != 0) {
      decodedPreconditionsV2.ledgerBounds = LedgerBounds.decode(stream);
    }
    int minSeqNumPresent = stream.readInt();
    if (minSeqNumPresent != 0) {
      decodedPreconditionsV2.minSeqNum = SequenceNumber.decode(stream);
    }
    decodedPreconditionsV2.minSeqAge = Duration.decode(stream);
    decodedPreconditionsV2.minSeqLedgerGap = Uint32.decode(stream);
    int extraSignersSize = stream.readInt();
    decodedPreconditionsV2.extraSigners = new SignerKey[extraSignersSize];
    for (int i = 0; i < extraSignersSize; i++) {
      decodedPreconditionsV2.extraSigners[i] = SignerKey.decode(stream);
    }
    return decodedPreconditionsV2;
  }

  public static PreconditionsV2 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PreconditionsV2 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
