// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCPHistoryEntry's original definition in the XDR file is:
 *
 * <pre>
 * union SCPHistoryEntry switch (int v)
 * {
 * case 0:
 *     SCPHistoryEntryV0 v0;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCPHistoryEntry implements XdrElement {
  private Integer discriminant;
  private SCPHistoryEntryV0 v0;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant);
    switch (discriminant) {
      case 0:
        v0.encode(stream);
        break;
    }
  }

  public static SCPHistoryEntry decode(XdrDataInputStream stream) throws IOException {
    SCPHistoryEntry decodedSCPHistoryEntry = new SCPHistoryEntry();
    Integer discriminant = stream.readInt();
    decodedSCPHistoryEntry.setDiscriminant(discriminant);
    switch (decodedSCPHistoryEntry.getDiscriminant()) {
      case 0:
        decodedSCPHistoryEntry.v0 = SCPHistoryEntryV0.decode(stream);
        break;
    }
    return decodedSCPHistoryEntry;
  }

  public static SCPHistoryEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPHistoryEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
