// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCSpecFunctionV0's original definition in the XDR file is:
 *
 * <pre>
 * struct SCSpecFunctionV0
 * {
 *     string doc&lt;SC_SPEC_DOC_LIMIT&gt;;
 *     SCSymbol name;
 *     SCSpecFunctionInputV0 inputs&lt;10&gt;;
 *     SCSpecTypeDef outputs&lt;1&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCSpecFunctionV0 implements XdrElement {
  private XdrString doc;
  private SCSymbol name;
  private SCSpecFunctionInputV0[] inputs;
  private SCSpecTypeDef[] outputs;

  public void encode(XdrDataOutputStream stream) throws IOException {
    doc.encode(stream);
    name.encode(stream);
    int inputsSize = getInputs().length;
    stream.writeInt(inputsSize);
    for (int i = 0; i < inputsSize; i++) {
      inputs[i].encode(stream);
    }
    int outputsSize = getOutputs().length;
    stream.writeInt(outputsSize);
    for (int i = 0; i < outputsSize; i++) {
      outputs[i].encode(stream);
    }
  }

  public static SCSpecFunctionV0 decode(XdrDataInputStream stream) throws IOException {
    SCSpecFunctionV0 decodedSCSpecFunctionV0 = new SCSpecFunctionV0();
    decodedSCSpecFunctionV0.doc = XdrString.decode(stream, Constants.SC_SPEC_DOC_LIMIT);
    decodedSCSpecFunctionV0.name = SCSymbol.decode(stream);
    int inputsSize = stream.readInt();
    decodedSCSpecFunctionV0.inputs = new SCSpecFunctionInputV0[inputsSize];
    for (int i = 0; i < inputsSize; i++) {
      decodedSCSpecFunctionV0.inputs[i] = SCSpecFunctionInputV0.decode(stream);
    }
    int outputsSize = stream.readInt();
    decodedSCSpecFunctionV0.outputs = new SCSpecTypeDef[outputsSize];
    for (int i = 0; i < outputsSize; i++) {
      decodedSCSpecFunctionV0.outputs[i] = SCSpecTypeDef.decode(stream);
    }
    return decodedSCSpecFunctionV0;
  }

  public static SCSpecFunctionV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCSpecFunctionV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
