// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCSpecUDTUnionV0's original definition in the XDR file is:
 *
 * <pre>
 * struct SCSpecUDTUnionV0
 * {
 *     string doc&lt;SC_SPEC_DOC_LIMIT&gt;;
 *     string lib&lt;80&gt;;
 *     string name&lt;60&gt;;
 *     SCSpecUDTUnionCaseV0 cases&lt;50&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCSpecUDTUnionV0 implements XdrElement {
  private XdrString doc;
  private XdrString lib;
  private XdrString name;
  private SCSpecUDTUnionCaseV0[] cases;

  public void encode(XdrDataOutputStream stream) throws IOException {
    doc.encode(stream);
    lib.encode(stream);
    name.encode(stream);
    int casesSize = getCases().length;
    stream.writeInt(casesSize);
    for (int i = 0; i < casesSize; i++) {
      cases[i].encode(stream);
    }
  }

  public static SCSpecUDTUnionV0 decode(XdrDataInputStream stream) throws IOException {
    SCSpecUDTUnionV0 decodedSCSpecUDTUnionV0 = new SCSpecUDTUnionV0();
    decodedSCSpecUDTUnionV0.doc = XdrString.decode(stream, Constants.SC_SPEC_DOC_LIMIT);
    decodedSCSpecUDTUnionV0.lib = XdrString.decode(stream, 80);
    decodedSCSpecUDTUnionV0.name = XdrString.decode(stream, 60);
    int casesSize = stream.readInt();
    decodedSCSpecUDTUnionV0.cases = new SCSpecUDTUnionCaseV0[casesSize];
    for (int i = 0; i < casesSize; i++) {
      decodedSCSpecUDTUnionV0.cases[i] = SCSpecUDTUnionCaseV0.decode(stream);
    }
    return decodedSCSpecUDTUnionV0;
  }

  public static SCSpecUDTUnionV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCSpecUDTUnionV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
