// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Signer's original definition in the XDR file is:
 *
 * <pre>
 * struct Signer
 * {
 *     SignerKey key;
 *     uint32 weight; // really only need 1 byte
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Signer implements XdrElement {
  private SignerKey key;
  private Uint32 weight;

  public void encode(XdrDataOutputStream stream) throws IOException {
    key.encode(stream);
    weight.encode(stream);
  }

  public static Signer decode(XdrDataInputStream stream) throws IOException {
    Signer decodedSigner = new Signer();
    decodedSigner.key = SignerKey.decode(stream);
    decodedSigner.weight = Uint32.decode(stream);
    return decodedSigner;
  }

  public static Signer fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Signer fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
