// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanAddressCredentials's original definition in the XDR file is:
 *
 * <pre>
 * struct SorobanAddressCredentials
 * {
 *     SCAddress address;
 *     int64 nonce;
 *     uint32 signatureExpirationLedger;
 *     SCVal signature;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanAddressCredentials implements XdrElement {
  private SCAddress address;
  private Int64 nonce;
  private Uint32 signatureExpirationLedger;
  private SCVal signature;

  public void encode(XdrDataOutputStream stream) throws IOException {
    address.encode(stream);
    nonce.encode(stream);
    signatureExpirationLedger.encode(stream);
    signature.encode(stream);
  }

  public static SorobanAddressCredentials decode(XdrDataInputStream stream) throws IOException {
    SorobanAddressCredentials decodedSorobanAddressCredentials = new SorobanAddressCredentials();
    decodedSorobanAddressCredentials.address = SCAddress.decode(stream);
    decodedSorobanAddressCredentials.nonce = Int64.decode(stream);
    decodedSorobanAddressCredentials.signatureExpirationLedger = Uint32.decode(stream);
    decodedSorobanAddressCredentials.signature = SCVal.decode(stream);
    return decodedSorobanAddressCredentials;
  }

  public static SorobanAddressCredentials fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanAddressCredentials fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
