// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanCredentials's original definition in the XDR file is:
 *
 * <pre>
 * union SorobanCredentials switch (SorobanCredentialsType type)
 * {
 * case SOROBAN_CREDENTIALS_SOURCE_ACCOUNT:
 *     void;
 * case SOROBAN_CREDENTIALS_ADDRESS:
 *     SorobanAddressCredentials address;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanCredentials implements XdrElement {
  private SorobanCredentialsType discriminant;
  private SorobanAddressCredentials address;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SOROBAN_CREDENTIALS_SOURCE_ACCOUNT:
        break;
      case SOROBAN_CREDENTIALS_ADDRESS:
        address.encode(stream);
        break;
    }
  }

  public static SorobanCredentials decode(XdrDataInputStream stream) throws IOException {
    SorobanCredentials decodedSorobanCredentials = new SorobanCredentials();
    SorobanCredentialsType discriminant = SorobanCredentialsType.decode(stream);
    decodedSorobanCredentials.setDiscriminant(discriminant);
    switch (decodedSorobanCredentials.getDiscriminant()) {
      case SOROBAN_CREDENTIALS_SOURCE_ACCOUNT:
        break;
      case SOROBAN_CREDENTIALS_ADDRESS:
        decodedSorobanCredentials.address = SorobanAddressCredentials.decode(stream);
        break;
    }
    return decodedSorobanCredentials;
  }

  public static SorobanCredentials fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanCredentials fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
