// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanTransactionData's original definition in the XDR file is:
 *
 * <pre>
 * struct SorobanTransactionData
 * {
 *     ExtensionPoint ext;
 *     SorobanResources resources;
 *     // Amount of the transaction `fee` allocated to the Soroban resource fees.
 *     // The fraction of `resourceFee` corresponding to `resources` specified
 *     // above is &#42;not&#42; refundable (i.e. fees for instructions, ledger I/O), as
 *     // well as fees for the transaction size.
 *     // The remaining part of the fee is refundable and the charged value is
 *     // based on the actual consumption of refundable resources (events, ledger
 *     // rent bumps).
 *     // The `inclusionFee` used for prioritization of the transaction is defined
 *     // as `tx.fee - resourceFee`.
 *     int64 resourceFee;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanTransactionData implements XdrElement {
  private ExtensionPoint ext;
  private SorobanResources resources;
  private Int64 resourceFee;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    resources.encode(stream);
    resourceFee.encode(stream);
  }

  public static SorobanTransactionData decode(XdrDataInputStream stream) throws IOException {
    SorobanTransactionData decodedSorobanTransactionData = new SorobanTransactionData();
    decodedSorobanTransactionData.ext = ExtensionPoint.decode(stream);
    decodedSorobanTransactionData.resources = SorobanResources.decode(stream);
    decodedSorobanTransactionData.resourceFee = Int64.decode(stream);
    return decodedSorobanTransactionData;
  }

  public static SorobanTransactionData fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanTransactionData fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
