// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SurveyResponseBody's original definition in the XDR file is:
 *
 * <pre>
 * union SurveyResponseBody switch (SurveyMessageResponseType type)
 * {
 * case SURVEY_TOPOLOGY_RESPONSE_V0:
 *     TopologyResponseBodyV0 topologyResponseBodyV0;
 * case SURVEY_TOPOLOGY_RESPONSE_V1:
 *     TopologyResponseBodyV1 topologyResponseBodyV1;
 * case SURVEY_TOPOLOGY_RESPONSE_V2:
 *     TopologyResponseBodyV2 topologyResponseBodyV2;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SurveyResponseBody implements XdrElement {
  private SurveyMessageResponseType discriminant;
  private TopologyResponseBodyV0 topologyResponseBodyV0;
  private TopologyResponseBodyV1 topologyResponseBodyV1;
  private TopologyResponseBodyV2 topologyResponseBodyV2;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SURVEY_TOPOLOGY_RESPONSE_V0:
        topologyResponseBodyV0.encode(stream);
        break;
      case SURVEY_TOPOLOGY_RESPONSE_V1:
        topologyResponseBodyV1.encode(stream);
        break;
      case SURVEY_TOPOLOGY_RESPONSE_V2:
        topologyResponseBodyV2.encode(stream);
        break;
    }
  }

  public static SurveyResponseBody decode(XdrDataInputStream stream) throws IOException {
    SurveyResponseBody decodedSurveyResponseBody = new SurveyResponseBody();
    SurveyMessageResponseType discriminant = SurveyMessageResponseType.decode(stream);
    decodedSurveyResponseBody.setDiscriminant(discriminant);
    switch (decodedSurveyResponseBody.getDiscriminant()) {
      case SURVEY_TOPOLOGY_RESPONSE_V0:
        decodedSurveyResponseBody.topologyResponseBodyV0 = TopologyResponseBodyV0.decode(stream);
        break;
      case SURVEY_TOPOLOGY_RESPONSE_V1:
        decodedSurveyResponseBody.topologyResponseBodyV1 = TopologyResponseBodyV1.decode(stream);
        break;
      case SURVEY_TOPOLOGY_RESPONSE_V2:
        decodedSurveyResponseBody.topologyResponseBodyV2 = TopologyResponseBodyV2.decode(stream);
        break;
    }
    return decodedSurveyResponseBody;
  }

  public static SurveyResponseBody fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SurveyResponseBody fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
