// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionSetV1's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionSetV1
 * {
 *     Hash previousLedgerHash;
 *     TransactionPhase phases&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionSetV1 implements XdrElement {
  private Hash previousLedgerHash;
  private TransactionPhase[] phases;

  public void encode(XdrDataOutputStream stream) throws IOException {
    previousLedgerHash.encode(stream);
    int phasesSize = getPhases().length;
    stream.writeInt(phasesSize);
    for (int i = 0; i < phasesSize; i++) {
      phases[i].encode(stream);
    }
  }

  public static TransactionSetV1 decode(XdrDataInputStream stream) throws IOException {
    TransactionSetV1 decodedTransactionSetV1 = new TransactionSetV1();
    decodedTransactionSetV1.previousLedgerHash = Hash.decode(stream);
    int phasesSize = stream.readInt();
    decodedTransactionSetV1.phases = new TransactionPhase[phasesSize];
    for (int i = 0; i < phasesSize; i++) {
      decodedTransactionSetV1.phases[i] = TransactionPhase.decode(stream);
    }
    return decodedTransactionSetV1;
  }

  public static TransactionSetV1 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionSetV1 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
