/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCAddressType;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SCValType;

public class Address {
    private static final SCValType TYPE = SCValType.SCV_ADDRESS;
    private final byte[] key;
    private final AddressType type;

    public Address(String address) {
        if (StrKey.isValidEd25519PublicKey(address)) {
            this.type = AddressType.ACCOUNT;
            this.key = StrKey.decodeEd25519PublicKey(address);
        } else if (StrKey.isValidContract(address)) {
            this.type = AddressType.CONTRACT;
            this.key = StrKey.decodeContract(address);
        } else {
            throw new IllegalArgumentException("Unsupported address type");
        }
    }

    public static Address fromAccount(byte[] accountId) {
        return new Address(StrKey.encodeEd25519PublicKey(accountId));
    }

    public static Address fromContract(byte[] contractId) {
        return new Address(StrKey.encodeContract(contractId));
    }

    public static Address fromSCAddress(SCAddress scAddress) {
        switch (scAddress.getDiscriminant()) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                return new Address(StrKey.encodeEd25519PublicKey(scAddress.getAccountId()));
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                return new Address(StrKey.encodeContract(scAddress.getContractId().getHash()));
            }
        }
        throw new IllegalArgumentException("Unsupported address type");
    }

    public static Address fromSCVal(SCVal scVal) {
        if (!TYPE.equals(scVal.getDiscriminant())) {
            throw new IllegalArgumentException(String.format("invalid scVal type, expected %s, but got %s", TYPE, scVal.getDiscriminant()));
        }
        return Address.fromSCAddress(scVal.getAddress());
    }

    public SCAddress toSCAddress() {
        SCAddress scAddress = new SCAddress();
        switch (this.type.ordinal()) {
            case 0: {
                scAddress.setDiscriminant(SCAddressType.SC_ADDRESS_TYPE_ACCOUNT);
                scAddress.setAccountId(KeyPair.fromPublicKey(this.key).getXdrAccountId());
                break;
            }
            case 1: {
                scAddress.setDiscriminant(SCAddressType.SC_ADDRESS_TYPE_CONTRACT);
                scAddress.setContractId(new Hash(this.key));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported address type");
            }
        }
        return scAddress;
    }

    public SCVal toSCVal() {
        SCVal scVal = new SCVal();
        scVal.setDiscriminant(TYPE);
        scVal.setAddress(this.toSCAddress());
        return scVal;
    }

    public byte[] getBytes() {
        return this.key;
    }

    public AddressType getAddressType() {
        return this.type;
    }

    public String toString() {
        switch (this.type.ordinal()) {
            case 0: {
                return StrKey.encodeEd25519PublicKey(this.key);
            }
            case 1: {
                return StrKey.encodeContract(this.key);
            }
        }
        throw new IllegalArgumentException("Unsupported address type");
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.key, other.key)) {
            return false;
        }
        AddressType this$type = this.type;
        AddressType other$type = other.type;
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.key);
        AddressType $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum AddressType {
        ACCOUNT,
        CONTRACT;

    }
}

