/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.xdr.Int32;

public final class Price {
    private final int numerator;
    private final int denominator;

    public static Price fromString(@NonNull String price) {
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        BigDecimal maxInt = new BigDecimal(Integer.MAX_VALUE);
        BigDecimal number = new BigDecimal(price);
        ArrayList<BigDecimal[]> fractions = new ArrayList<BigDecimal[]>();
        fractions.add(new BigDecimal[]{new BigDecimal(0), new BigDecimal(1)});
        fractions.add(new BigDecimal[]{new BigDecimal(1), new BigDecimal(0)});
        int i = 2;
        while (number.compareTo(maxInt) <= 0) {
            BigDecimal a = number.setScale(0, RoundingMode.FLOOR);
            BigDecimal f = number.subtract(a);
            BigDecimal h = a.multiply(((BigDecimal[])fractions.get(i - 1))[0]).add(((BigDecimal[])fractions.get(i - 2))[0]);
            BigDecimal k = a.multiply(((BigDecimal[])fractions.get(i - 1))[1]).add(((BigDecimal[])fractions.get(i - 2))[1]);
            if (h.compareTo(maxInt) > 0 || k.compareTo(maxInt) > 0) break;
            fractions.add(new BigDecimal[]{h, k});
            if (f.compareTo(BigDecimal.ZERO) == 0) break;
            number = new BigDecimal(1).divide(f, 20, RoundingMode.HALF_UP);
            ++i;
        }
        BigDecimal n = ((BigDecimal[])fractions.get(fractions.size() - 1))[0];
        BigDecimal d = ((BigDecimal[])fractions.get(fractions.size() - 1))[1];
        return new Price(n.intValue(), d.intValue());
    }

    public static Price fromXdr(org.stellar.sdk.xdr.Price price) {
        return new Price(price.getN().getInt32(), price.getD().getInt32());
    }

    public org.stellar.sdk.xdr.Price toXdr() {
        org.stellar.sdk.xdr.Price xdr = new org.stellar.sdk.xdr.Price();
        Int32 n = new Int32();
        Int32 d = new Int32();
        n.setInt32(this.numerator);
        d.setInt32(this.denominator);
        xdr.setN(n);
        xdr.setD(d);
        return xdr;
    }

    public String toString() {
        MathContext mc = MathContext.DECIMAL64;
        BigDecimal result = new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), mc);
        return result.toString();
    }

    @Generated
    public Price(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Generated
    public int getNumerator() {
        return this.numerator;
    }

    @Generated
    public int getDenominator() {
        return this.denominator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Price)) {
            return false;
        }
        Price other = (Price)o;
        if (this.getNumerator() != other.getNumerator()) {
            return false;
        }
        return this.getDenominator() == other.getDenominator();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumerator();
        result = result * 59 + this.getDenominator();
        return result;
    }
}

